/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ShowTables
extends Statement {
    @Nullable
    private final Identifier dbName;
    private final boolean isDetails;

    public ShowTables(NodeLocation location, boolean isDetails) {
        super(Objects.requireNonNull(location, "location is null"));
        this.dbName = null;
        this.isDetails = isDetails;
    }

    public ShowTables(NodeLocation location, Identifier dbName, boolean isDetails) {
        super(Objects.requireNonNull(location, "location is null"));
        this.dbName = Objects.requireNonNull(dbName, "dbName is null");
        this.isDetails = isDetails;
    }

    public Optional<Identifier> getDbName() {
        return Optional.ofNullable(this.dbName);
    }

    public boolean isDetails() {
        return this.isDetails;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowTables(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dbName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowTables o = (ShowTables)obj;
        return Objects.equals(this.dbName, o.dbName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dbName", (Object)this.dbName).toString();
    }
}

