/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;

public class CreateView
extends CreateTable {
    private final PartialPath prefixPath;
    private final boolean replace;
    private final boolean restrict;

    public CreateView(@Nullable NodeLocation location, QualifiedName name, List<ColumnDefinition> elements, @Nullable String charsetName, @Nullable String comment, List<Property> properties, PartialPath prefixPath, boolean replace, boolean restrict) {
        super(location, name, elements, false, charsetName, comment, properties);
        this.prefixPath = prefixPath;
        this.replace = replace;
        this.restrict = restrict;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateView(this, context);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.prefixPath, ((CreateView)o).prefixPath) && this.replace == ((CreateView)o).replace && this.restrict == ((CreateView)o).restrict;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefixPath, this.replace, this.restrict);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("elements", this.getElements()).add("ifNotExists", this.isIfNotExists()).add("charsetName", this.getCharsetName()).add("properties", this.getProperties()).add("prefixPath", (Object)this.prefixPath).add("replace", this.replace).add("restrict", this.restrict).toString();
    }
}

