/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TwoChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;

public class ApplyNode
extends TwoChildProcessNode {
    private final List<Symbol> correlation;
    private final Map<Symbol, SetExpression> subqueryAssignments;
    private final Node originSubquery;

    public ApplyNode(PlanNodeId id, PlanNode input, PlanNode subquery, Map<Symbol, SetExpression> subqueryAssignments, List<Symbol> correlation, Node originSubquery) {
        super(id, input, subquery);
        Objects.requireNonNull(subqueryAssignments, "subqueryAssignments is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(originSubquery, "originSubquery is null");
        if (input != null) {
            Preconditions.checkArgument((boolean)input.getOutputSymbols().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        }
        this.subqueryAssignments = subqueryAssignments;
        this.correlation = ImmutableList.copyOf(correlation);
        this.originSubquery = originSubquery;
    }

    public PlanNode getInput() {
        return this.leftChild;
    }

    public PlanNode getSubquery() {
        return this.rightChild;
    }

    public Map<Symbol, SetExpression> getSubqueryAssignments() {
        return this.subqueryAssignments;
    }

    public List<Symbol> getCorrelation() {
        return this.correlation;
    }

    public Node getOriginSubquery() {
        return this.originSubquery;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.leftChild.getOutputSymbols()).addAll(this.subqueryAssignments.keySet()).build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitApply(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new ApplyNode(this.getPlanNodeId(), newChildren.get(0), newChildren.get(1), this.subqueryAssignments, this.correlation, this.originSubquery);
    }

    @Override
    public PlanNode clone() {
        return new ApplyNode(this.getPlanNodeId(), null, null, this.subqueryAssignments, this.correlation, this.originSubquery);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static enum Quantifier {
        ALL,
        ANY,
        SOME;

    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL;

    }

    public static class QuantifiedComparison
    implements SetExpression {
        private final Operator operator;
        private final Quantifier quantifier;
        private final Symbol value;
        private final Symbol reference;

        public QuantifiedComparison(Operator operator, Quantifier quantifier, Symbol value, Symbol reference) {
            this.operator = operator;
            this.quantifier = quantifier;
            this.value = value;
            this.reference = reference;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Quantifier getQuantifier() {
            return this.quantifier;
        }

        public Symbol getValue() {
            return this.value;
        }

        public Symbol getReference() {
            return this.reference;
        }

        @Override
        public List<Symbol> inputs() {
            return ImmutableList.of((Object)this.value, (Object)this.reference);
        }
    }

    public static class Exists
    implements SetExpression {
        @Override
        public List<Symbol> inputs() {
            return ImmutableList.of();
        }
    }

    public static class In
    implements SetExpression {
        private final Symbol value;
        private final Symbol reference;

        public In(Symbol value, Symbol reference) {
            this.value = value;
            this.reference = reference;
        }

        public Symbol getValue() {
            return this.value;
        }

        public Symbol getReference() {
            return this.reference;
        }

        @Override
        public List<Symbol> inputs() {
            return ImmutableList.of((Object)this.value, (Object)this.reference);
        }
    }

    public static interface SetExpression {
        public List<Symbol> inputs();
    }
}

