/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionDiskTSMIterator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileOutput;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.apache.tsfile.write.writer.tsmiterator.TSMIterator;

public class CompactionTsFileWriter
extends TsFileIOWriter {
    CompactionType type;
    private volatile boolean isWritingAligned = false;
    private boolean isEmptyTargetFile = true;
    private IDeviceID currentDeviceId;

    public CompactionTsFileWriter(File file, long maxMetadataSize, CompactionType type) throws IOException {
        super(file, maxMetadataSize);
        this.type = type;
        this.out = new CompactionTsFileOutput(this.out, CompactionTaskManager.getInstance().getMergeWriteRateLimiter());
    }

    public void markStartingWritingAligned() {
        this.isWritingAligned = true;
    }

    public void markEndingWritingAligned() {
        this.isWritingAligned = false;
    }

    public void writeChunk(IChunkWriter chunkWriter) throws IOException {
        boolean isAligned = chunkWriter instanceof AlignedChunkWriterImpl;
        long beforeOffset = this.getPos();
        if (!chunkWriter.isEmpty()) {
            this.isEmptyTargetFile = false;
        }
        chunkWriter.writeToFileWriter((TsFileIOWriter)this);
        long writtenDataSize = this.getPos() - beforeOffset;
        CompactionMetrics.getInstance().recordWriteInfo(this.type, isAligned ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, writtenDataSize);
    }

    public void writeChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        long beforeOffset = this.getPos();
        if (chunkMetadata.getNumOfPoints() != 0L) {
            this.isEmptyTargetFile = false;
        }
        super.writeChunk(chunk, chunkMetadata);
        long writtenDataSize = this.getPos() - beforeOffset;
        CompactionMetrics.getInstance().recordWriteInfo(this.type, this.isWritingAligned ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, writtenDataSize);
    }

    public void writeEmptyValueChunk(String measurementId, CompressionType compressionType, TSDataType tsDataType, TSEncoding encodingType, Statistics<? extends Serializable> statistics) throws IOException {
        long beforeOffset = this.getPos();
        super.writeEmptyValueChunk(measurementId, compressionType, tsDataType, encodingType, statistics);
        long writtenDataSize = this.getPos() - beforeOffset;
        CompactionMetrics.getInstance().recordWriteInfo(this.type, CompactionIoDataType.ALIGNED, writtenDataSize);
    }

    public int checkMetadataSizeAndMayFlush() throws IOException {
        int size = super.checkMetadataSizeAndMayFlush();
        CompactionMetrics.getInstance().recordWriteInfo(this.type, CompactionIoDataType.METADATA, size);
        return size;
    }

    public int startChunkGroup(IDeviceID deviceId) throws IOException {
        this.currentDeviceId = deviceId;
        return super.startChunkGroup(deviceId);
    }

    public void endChunkGroup() throws IOException {
        if (this.currentDeviceId == null || this.chunkMetadataList.isEmpty()) {
            return;
        }
        String tableName = this.currentDeviceId.getTableName();
        TableSchema tableSchema = (TableSchema)this.getSchema().getTableSchemaMap().get(tableName);
        boolean generateTableSchemaForCurrentChunkGroup = tableSchema != null;
        this.setGenerateTableSchema(generateTableSchemaForCurrentChunkGroup);
        super.endChunkGroup();
        this.currentDeviceId = null;
    }

    public void endFile() throws IOException {
        this.removeUnusedTableSchema();
        long beforeSize = this.getPos();
        super.endFile();
        long writtenDataSize = this.getPos() - beforeSize;
        CompactionMetrics.getInstance().recordWriteInfo(this.type, CompactionIoDataType.METADATA, writtenDataSize);
    }

    protected TSMIterator getTSMIterator() throws IOException {
        return this.hasChunkMetadataInDisk ? new CompactionDiskTSMIterator(this.type, this.chunkMetadataTempFile, this.chunkGroupMetadataList, this.endPosInCMTForDevice) : TSMIterator.getTSMIteratorInMemory((List)this.chunkGroupMetadataList);
    }

    public boolean isEmptyTargetFile() {
        return this.isEmptyTargetFile;
    }

    private void removeUnusedTableSchema() {
        Map tableSchemaMap = this.getSchema().getTableSchemaMap();
        Iterator iterator = tableSchemaMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List columnTypes = ((TableSchema)entry.getValue()).getColumnTypes();
            if (columnTypes.contains(ColumnCategory.FIELD)) continue;
            iterator.remove();
        }
    }
}

