/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.TreeAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.window.ConditionWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.ConditionWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public class ConditionWindowManager
implements IWindowManager {
    private final ConditionWindow conditionWindow;
    private boolean initialized;
    private boolean needSkip;
    private boolean isFirstSkip;
    private final AccumulatorFactory.KeepEvaluator keepEvaluator;

    public ConditionWindowManager(ConditionWindowParameter conditionWindowParameter) {
        this.conditionWindow = new ConditionWindow(conditionWindowParameter);
        this.needSkip = true;
        this.keepEvaluator = AccumulatorFactory.initKeepEvaluator(conditionWindowParameter.getKeepExpression());
    }

    @Override
    public boolean isCurWindowInit() {
        return this.initialized;
    }

    @Override
    public void initCurWindow() {
        this.initialized = true;
        this.conditionWindow.setTimeInitialized(false);
        this.conditionWindow.setKeep(0L);
    }

    @Override
    public boolean hasNext(boolean hasMoreData) {
        return hasMoreData;
    }

    @Override
    public void next() {
        this.needSkip = true;
        this.initialized = false;
        this.isFirstSkip = true;
    }

    @Override
    public IWindow getCurWindow() {
        return this.conditionWindow;
    }

    private boolean skipFirstPhrase(Column controlColumn, int index) {
        if (!this.isFirstSkip) {
            return false;
        }
        return controlColumn.isNull(index) || !controlColumn.getBoolean(index);
    }

    private boolean skipSecondPhrase(Column controlColumn, int index) {
        if (this.isFirstSkip) {
            return false;
        }
        return !controlColumn.isNull(index) && controlColumn.getBoolean(index);
    }

    private boolean needBreak(Column controlColumn, int index) {
        if (this.isIgnoringNull() && controlColumn.isNull(index)) {
            return false;
        }
        return this.skipFirstPhrase(controlColumn, index) || this.skipSecondPhrase(controlColumn, index);
    }

    private void updateTime(long currentTime) {
        if (this.conditionWindow.getStartTime() > currentTime) {
            this.conditionWindow.setStartTime(currentTime);
        }
        if (this.conditionWindow.getEndTime() < currentTime) {
            this.conditionWindow.setEndTime(currentTime);
        }
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        int i;
        if (!this.needSkip || inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        Column controlColumn = this.conditionWindow.getControlColumn(inputTsBlock);
        Column timeColumn = inputTsBlock.getTimeColumn();
        int k = 0;
        int size = inputTsBlock.getPositionCount();
        for (i = 0; i < size && !this.needBreak(controlColumn, i); ++i) {
            if (this.isIgnoringNull() && controlColumn.isNull(i) || !this.isFirstSkip) continue;
            ++k;
            this.updateTime(timeColumn.getLong(i));
        }
        if (this.isFirstSkip) {
            if (i != size) {
                this.isFirstSkip = false;
            }
            this.conditionWindow.setKeep(this.conditionWindow.getKeep() + (long)k);
            return inputTsBlock.subTsBlock(i);
        }
        if (i < size) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(i);
    }

    @Override
    public TsBlockBuilder createResultTsBlockBuilder(List<TreeAggregator> aggregators) {
        List<TSDataType> dataTypes = this.getResultDataTypes(aggregators);
        if (this.conditionWindow.isOutputEndTime()) {
            dataTypes.add(0, TSDataType.INT64);
        }
        return new TsBlockBuilder(dataTypes);
    }

    @Override
    public void appendAggregationResult(TsBlockBuilder resultTsBlockBuilder, List<TreeAggregator> aggregators) {
        if (!this.keepEvaluator.apply(this.conditionWindow.getKeep())) {
            return;
        }
        long endTime = this.conditionWindow.isOutputEndTime() ? this.conditionWindow.getEndTime() : -1L;
        this.outputAggregators(aggregators, resultTsBlockBuilder, this.conditionWindow.getStartTime(), endTime);
    }

    @Override
    public boolean needSkipInAdvance() {
        return true;
    }

    @Override
    public boolean isIgnoringNull() {
        return this.conditionWindow.ignoringNull();
    }
}

