/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum MonitoringMode implements UaEnumeration
{
    Disabled(0),
    Sampling(1),
    Reporting(2);

    private final int value;

    private MonitoringMode(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static MonitoringMode from(int value) {
        switch (value) {
            case 0: {
                return Disabled;
            }
            case 1: {
                return Sampling;
            }
            case 2: {
                return Reporting;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=716");
    }

    public static class Codec
    extends GenericDataTypeCodec<MonitoringMode> {
        @Override
        public Class<MonitoringMode> getType() {
            return MonitoringMode.class;
        }

        @Override
        public MonitoringMode decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, MonitoringMode.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoringMode value) {
            encoder.writeEnum(null, value);
        }
    }
}

