/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.tsfile.common.cache.LRUCache;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;

public class CachedChunkLoaderImpl
implements IChunkLoader {
    private static final int DEFAULT_CHUNK_CACHE_SIZE = 1000;
    private TsFileSequenceReader reader;
    private LRUCache<ChunkCacheKey, Chunk> chunkCache;

    public CachedChunkLoaderImpl(TsFileSequenceReader fileSequenceReader) {
        this(fileSequenceReader, 1000);
    }

    public CachedChunkLoaderImpl(TsFileSequenceReader fileSequenceReader, int cacheSize) {
        this.reader = fileSequenceReader;
        this.chunkCache = new LRUCache<ChunkCacheKey, Chunk>(cacheSize){

            @Override
            protected Chunk loadObjectByKey(ChunkCacheKey chunkCacheKey) throws IOException {
                return CachedChunkLoaderImpl.this.reader.readMemChunk(chunkCacheKey);
            }
        };
    }

    @Override
    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        Chunk chunk = this.chunkCache.get(new ChunkCacheKey(chunkMetaData));
        return new Chunk(chunk.getHeader(), chunk.getData().duplicate(), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics(), this.reader.getEncryptParam());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) throws IOException {
        Chunk chunk = this.chunkCache.get(new ChunkCacheKey((ChunkMetadata)chunkMetaData));
        return new ChunkReader(new Chunk(chunk.getHeader(), chunk.getData().duplicate(), chunkMetaData.getDeleteIntervalList(), chunkMetaData.getStatistics(), this.reader.getEncryptParam()), globalTimeFilter);
    }

    public static class ChunkCacheKey {
        private final Long offsetOfChunkHeader;
        private final String measurementUid;
        private final List<TimeRange> deleteIntervalList;
        private final Statistics<? extends Serializable> statistics;

        public ChunkCacheKey(ChunkMetadata chunkMetadata) {
            this.offsetOfChunkHeader = chunkMetadata.getOffsetOfChunkHeader();
            this.measurementUid = chunkMetadata.getMeasurementUid();
            this.deleteIntervalList = chunkMetadata.getDeleteIntervalList();
            this.statistics = chunkMetadata.getStatistics();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkCacheKey that = (ChunkCacheKey)o;
            return Objects.equals(this.offsetOfChunkHeader, that.offsetOfChunkHeader);
        }

        public int hashCode() {
            return Objects.hash(this.offsetOfChunkHeader);
        }

        public Long getOffsetOfChunkHeader() {
            return this.offsetOfChunkHeader;
        }

        public String getMeasurementUid() {
            return this.measurementUid;
        }

        public List<TimeRange> getDeleteIntervalList() {
            return this.deleteIntervalList;
        }

        public Statistics<? extends Serializable> getStatistics() {
            return this.statistics;
        }
    }
}

