/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BooleanLiteral
extends Literal {
    public static final BooleanLiteral TRUE_LITERAL = new BooleanLiteral("true");
    public static final BooleanLiteral FALSE_LITERAL = new BooleanLiteral("false");
    private final boolean value;

    public BooleanLiteral(String value) {
        super(null);
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((value.toLowerCase(Locale.ENGLISH).equals("true") || value.toLowerCase(Locale.ENGLISH).equals("false") ? 1 : 0) != 0);
        this.value = value.toLowerCase(Locale.ENGLISH).equals("true");
    }

    public BooleanLiteral(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((value.toLowerCase(Locale.ENGLISH).equals("true") || value.toLowerCase(Locale.ENGLISH).equals("false") ? 1 : 0) != 0);
        this.value = value.toLowerCase(Locale.ENGLISH).equals("true");
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBooleanLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanLiteral other = (BooleanLiteral)obj;
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!BooleanLiteral.sameClass(this, other)) {
            return false;
        }
        return this.value == ((BooleanLiteral)other).value;
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.BOOLEAN_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.value, (OutputStream)stream);
    }

    public BooleanLiteral(ByteBuffer byteBuffer) {
        super(null);
        this.value = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    @Override
    public Object getTsValue() {
        return this.value;
    }
}

