/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractRegionScanDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.RegionScanForActiveDeviceUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class ActiveDeviceRegionScanOperator
extends AbstractRegionScanDataSourceOperator {
    private final Map<IDeviceID, DeviceContext> deviceContextMap;
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ActiveDeviceRegionScanOperator.class) + RamUsageEstimator.shallowSizeOfInstance(Map.class);

    public ActiveDeviceRegionScanOperator(OperatorContext operatorContext, PlanNodeId sourceId, Map<IDeviceID, DeviceContext> deviceContextMap, Filter timeFilter, Map<IDeviceID, Long> ttlCache, boolean outputCount) {
        this.outputCount = outputCount;
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.deviceContextMap = deviceContextMap;
        this.regionScanUtil = new RegionScanForActiveDeviceUtil(timeFilter, ttlCache);
    }

    @Override
    protected boolean getNextTsFileHandle() throws IOException, IllegalPathException {
        return ((RegionScanForActiveDeviceUtil)this.regionScanUtil).nextTsFileHandle(this.deviceContextMap);
    }

    @Override
    protected boolean isAllDataChecked() {
        return this.deviceContextMap.isEmpty();
    }

    @Override
    protected void updateActiveData() {
        List<IDeviceID> activeDevices = ((RegionScanForActiveDeviceUtil)this.regionScanUtil).getActiveDevices();
        if (this.outputCount) {
            this.count += (long)activeDevices.size();
            activeDevices.forEach(this.deviceContextMap.keySet()::remove);
        } else {
            TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = this.resultTsBlockBuilder.getValueColumnBuilders();
            for (IDeviceID deviceID : activeDevices) {
                DeviceContext deviceContext = this.deviceContextMap.get(deviceID);
                int templateId = deviceContext.getTemplateId();
                long ttl = DataNodeTTLCache.getInstance().getTTLForTree(deviceID);
                String ttlStr = ttl == Long.MAX_VALUE ? "INF" : String.valueOf(ttl);
                timeColumnBuilder.writeLong(-1L);
                columnBuilders[0].writeBinary(new Binary(deviceID.toString(), TSFileConfig.STRING_CHARSET));
                columnBuilders[1].writeBinary(new Binary(String.valueOf(this.deviceContextMap.get(deviceID).isAligned()), TSFileConfig.STRING_CHARSET));
                if (templateId != -1) {
                    columnBuilders[2].writeBinary(new Binary(String.valueOf(ClusterTemplateManager.getInstance().getTemplate(templateId).getName()), TSFileConfig.STRING_CHARSET));
                } else {
                    columnBuilders[2].appendNull();
                }
                columnBuilders[3].writeBinary(new Binary(ttlStr, TSFileConfig.STRING_CHARSET));
                this.resultTsBlockBuilder.declarePosition();
                this.deviceContextMap.remove(deviceID);
            }
        }
    }

    @Override
    protected List<TSDataType> getResultDataTypes() {
        if (this.outputCount) {
            return ColumnHeaderConstant.countDevicesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        }
        return ColumnHeaderConstant.showDevicesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + INSTANCE_SIZE;
    }
}

