/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.client.request.AsyncRequestRPCHandler;
import org.apache.iotdb.confignode.client.CnToCnNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.ConfigNodeTSStatusRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.SubmitTestConnectionTaskToConfigNodeRPCHandler;

public abstract class ConfigNodeAsyncRequestRPCHandler<Response>
extends AsyncRequestRPCHandler<Response, CnToCnNodeRequestType, TConfigNodeLocation> {
    protected ConfigNodeAsyncRequestRPCHandler(CnToCnNodeRequestType configNodeRequestType, int requestId, TConfigNodeLocation targetNode, Map<Integer, TConfigNodeLocation> integerTConfigNodeLocationMap, Map<Integer, Response> integerResponseMap, CountDownLatch countDownLatch) {
        super((Object)configNodeRequestType, requestId, (Object)targetNode, integerTConfigNodeLocationMap, integerResponseMap, countDownLatch);
    }

    protected String generateFormattedTargetLocation(TConfigNodeLocation configNodeLocation) {
        return "{id=" + ((TConfigNodeLocation)this.targetNode).getConfigNodeId() + ", internalEndPoint=" + ((TConfigNodeLocation)this.targetNode).getInternalEndPoint() + "}";
    }

    public static ConfigNodeAsyncRequestRPCHandler<?> buildHandler(AsyncRequestContext<?, ?, CnToCnNodeRequestType, TConfigNodeLocation> context, int requestId, TConfigNodeLocation targetConfigNode) {
        CnToCnNodeRequestType requestType = (CnToCnNodeRequestType)((Object)context.getRequestType());
        Map nodeLocationMap = context.getNodeLocationMap();
        Map responseMap = context.getResponseMap();
        CountDownLatch countDownLatch = context.getCountDownLatch();
        switch (requestType) {
            case SUBMIT_TEST_CONNECTION_TASK: {
                return new SubmitTestConnectionTaskToConfigNodeRPCHandler(requestType, requestId, targetConfigNode, (Map<Integer, TConfigNodeLocation>)nodeLocationMap, responseMap, countDownLatch);
            }
        }
        return new ConfigNodeTSStatusRPCHandler(requestType, requestId, targetConfigNode, (Map<Integer, TConfigNodeLocation>)nodeLocationMap, responseMap, countDownLatch);
    }
}

