/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.ImportDataScanTool;

public class AsyncImportData
extends AbstractDataTool
implements Runnable {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static SessionPool sessionPool;

    protected static void setTimeZone() throws IoTDBConnectionException, StatementExecutionException {
        if (timeZoneID != null) {
            sessionPool.setTimeZone(timeZoneID);
            zoneId = sessionPool.getZoneId();
        }
    }

    @Override
    public void run() {
        try {
            String filePath;
            while ((filePath = ImportDataScanTool.pollFromQueue()) != null) {
                File file = new File(filePath);
                if (file.getName().endsWith("sql")) {
                    AsyncImportData.importFromSqlFile(file);
                    continue;
                }
                AsyncImportData.importFromSingleFile(file);
            }
        }
        catch (Exception e) {
            ioTPrinter.println("Unexpected error occurred: " + e.getMessage());
        }
    }

    protected static void processSuccessFile() {
        loadFileSuccessfulNum.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFromSqlFile(File file) {
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
        try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));){
            Object sql;
            while ((sql = br.readLine()) != null) {
                try {
                    sessionPool.executeNonQueryStatement((String)sql);
                }
                catch (IoTDBConnectionException | StatementExecutionException throwable) {
                    failedRecords.add(Arrays.asList(sql));
                }
            }
            AsyncImportData.processSuccessFile();
        }
        catch (IOException e) {
            ioTPrinter.println("SQL file read exception because: " + e.getMessage());
        }
        if (!failedRecords.isEmpty()) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(failedFilePath);
                for (List list : failedRecords) {
                    writer.write(list.get(0).toString() + "\n");
                }
            }
            catch (IOException e) {
                ioTPrinter.println("Cannot dump fail result because: " + e.getMessage());
            }
            finally {
                if (ObjectUtils.isNotEmpty((Object)writer)) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void importFromSingleFile(File file) {
        if (file.getName().endsWith("csv") || file.getName().endsWith("txt")) {
            try {
                CSVParser csvRecords = AsyncImportData.readCsvFile(file.getAbsolutePath());
                List headerNames = csvRecords.getHeaderNames();
                Stream records = csvRecords.stream();
                if (headerNames.isEmpty()) {
                    ioTPrinter.println("Empty file!");
                    return;
                }
                if (!timeColumn.equalsIgnoreCase(AsyncImportData.filterBomHeader((String)headerNames.get(0)))) {
                    ioTPrinter.println("The first field of header must be `Time`!");
                    return;
                }
                String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                if (!deviceColumn.equalsIgnoreCase((String)headerNames.get(1))) {
                    AsyncImportData.writeDataAlignedByTime(sessionPool, (List<String>)headerNames, (Stream<CSVRecord>)records, failedFilePath);
                } else {
                    AsyncImportData.writeDataAlignedByDevice(sessionPool, (List<String>)headerNames, (Stream<CSVRecord>)records, failedFilePath);
                }
                AsyncImportData.processSuccessFile();
            }
            catch (IOException | IllegalPathException e) {
                ioTPrinter.println("CSV file read exception because: " + e.getMessage());
            }
        } else {
            ioTPrinter.println("The file name must end with \"csv\" or \"txt\"!");
        }
    }

    public static void setSessionPool(SessionPool sessionPool) {
        AsyncImportData.sessionPool = sessionPool;
    }

    public static void setAligned(Boolean aligned) {
        AsyncImportData.aligned = aligned;
    }
}

