/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.persistence.ByteBufDataType;
import io.moquette.persistence.SerdesUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttProperties;
import java.nio.ByteBuffer;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.StringDataType;

class PropertyDataType
extends BasicDataType<MqttProperties.MqttProperty> {
    private final ByteBufDataType binaryDataType = new ByteBufDataType();

    PropertyDataType() {
    }

    public int getMemory(MqttProperties.MqttProperty property) {
        int propSize = 4;
        if (property instanceof MqttProperties.StringProperty) {
            MqttProperties.StringProperty stringProp = (MqttProperties.StringProperty)property;
            propSize += StringDataType.INSTANCE.getMemory((String)stringProp.value());
        } else if (property instanceof MqttProperties.IntegerProperty) {
            propSize += 4;
        } else if (property instanceof MqttProperties.BinaryProperty) {
            MqttProperties.BinaryProperty byteArrayProp = (MqttProperties.BinaryProperty)property;
            propSize += this.binaryDataType.getMemory(Unpooled.wrappedBuffer((byte[])((byte[])byteArrayProp.value())));
        }
        return 1 + propSize;
    }

    public void write(WriteBuffer buff, MqttProperties.MqttProperty property) {
        if (property instanceof MqttProperties.StringProperty) {
            MqttProperties.StringProperty stringProp = (MqttProperties.StringProperty)property;
            PropertyDataType.writePropertyType(buff, MqttPropertyEnum.STRING);
            buff.putInt(stringProp.propertyId());
            StringDataType.INSTANCE.write(buff, (String)stringProp.value());
        } else if (property instanceof MqttProperties.IntegerProperty) {
            MqttProperties.IntegerProperty intProp = (MqttProperties.IntegerProperty)property;
            PropertyDataType.writePropertyType(buff, MqttPropertyEnum.INTEGER);
            buff.putInt(intProp.propertyId());
            buff.putInt(((Integer)intProp.value()).intValue());
        } else if (property instanceof MqttProperties.BinaryProperty) {
            MqttProperties.BinaryProperty byteArrayProp = (MqttProperties.BinaryProperty)property;
            PropertyDataType.writePropertyType(buff, MqttPropertyEnum.BINARY);
            this.binaryDataType.write(buff, Unpooled.wrappedBuffer((byte[])((byte[])byteArrayProp.value())));
        }
    }

    private static void writePropertyType(WriteBuffer buff, MqttPropertyEnum mqttPropertyEnum) {
        buff.put((byte)mqttPropertyEnum.ordinal());
    }

    public MqttProperties.MqttProperty read(ByteBuffer buff) {
        return SerdesUtils.readSingleProperty(buff, buffer -> {
            ByteBuf byteArray = this.binaryDataType.read((ByteBuffer)buffer);
            return byteArray.array();
        });
    }

    public MqttProperties.MqttProperty[] createStorage(int size) {
        return new MqttProperties.MqttProperty[size];
    }

    static enum MqttPropertyEnum {
        STRING,
        INTEGER,
        BINARY;

    }
}

