/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.client.container.PipeConsensusClientMgrContainer;
import org.apache.iotdb.commons.client.sync.SyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.PipeConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupModifyPeerException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.IllegalPeerEndpointException;
import org.apache.iotdb.consensus.exception.IllegalPeerNumException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.consensus.pipe.PipeConsensusServerImpl;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeGuardian;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeManager;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.service.PipeConsensusRPCService;
import org.apache.iotdb.consensus.pipe.service.PipeConsensusRPCServiceProcessor;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensus
implements IConsensus {
    private static final String CONSENSUS_PIPE_GUARDIAN_TASK_ID = "consensus_pipe_guardian";
    private static final String CLASS_NAME = PipeConsensus.class.getSimpleName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensus.class);
    private final TEndPoint thisNode;
    private final int thisNodeId;
    private final File storageDir;
    private final IStateMachine.Registry registry;
    private final Map<ConsensusGroupId, PipeConsensusServerImpl> stateMachineMap = new ConcurrentHashMap<ConsensusGroupId, PipeConsensusServerImpl>();
    private final PipeConsensusRPCService rpcService;
    private final RegisterManager registerManager = new RegisterManager();
    private final ReentrantLock stateMachineMapLock = new ReentrantLock();
    private final PipeConsensusConfig config;
    private final ConsensusPipeManager consensusPipeManager;
    private final ConsensusPipeGuardian consensusPipeGuardian;
    private final IClientManager<TEndPoint, AsyncPipeConsensusServiceClient> asyncClientManager;
    private final IClientManager<TEndPoint, SyncPipeConsensusServiceClient> syncClientManager;
    private Map<ConsensusGroupId, List<Peer>> correctPeerListBeforeStart = null;

    public PipeConsensus(ConsensusConfig config, IStateMachine.Registry registry) {
        this.thisNode = config.getThisNodeEndPoint();
        this.thisNodeId = config.getThisNodeId();
        this.storageDir = new File(config.getStorageDir());
        this.config = config.getPipeConsensusConfig();
        this.registry = registry;
        this.rpcService = new PipeConsensusRPCService(this.thisNode, config.getPipeConsensusConfig());
        this.consensusPipeManager = new ConsensusPipeManager(config.getPipeConsensusConfig().getPipe(), config.getPipeConsensusConfig().getReplicateMode());
        this.consensusPipeGuardian = config.getPipeConsensusConfig().getPipe().getConsensusPipeGuardian();
        this.asyncClientManager = PipeConsensusClientMgrContainer.getInstance().getAsyncClientManager();
        this.syncClientManager = PipeConsensusClientMgrContainer.getInstance().getSyncClientManager();
    }

    @Override
    public synchronized void start() throws IOException {
        this.initAndRecover();
        this.rpcService.initSyncedServiceImpl(new PipeConsensusRPCServiceProcessor(this, this.config.getPipe()));
        try {
            this.registerManager.register((IService)this.rpcService);
        }
        catch (StartupException e) {
            throw new IOException(e);
        }
        this.consensusPipeGuardian.start(CONSENSUS_PIPE_GUARDIAN_TASK_ID, this::checkAllConsensusPipe, this.config.getPipe().getConsensusPipeGuardJobIntervalInSeconds());
    }

    private void initAndRecover() throws IOException {
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdirs()) {
                LOGGER.warn("Unable to create consensus dir at {}", (Object)this.storageDir);
                throw new IOException(String.format("Unable to create consensus dir at %s", this.storageDir));
            }
        } else {
            CompletionStage completionStage = CompletableFuture.runAsync(() -> {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storageDir.toPath());){
                    for (Path path : stream) {
                        ConsensusGroupId consensusGroupId = this.parsePeerFileName(path.getFileName().toString());
                        PipeConsensusServerImpl consensus = new PipeConsensusServerImpl(new Peer(consensusGroupId, this.thisNodeId, this.thisNode), (IStateMachine)this.registry.apply(consensusGroupId), path.toString(), new ArrayList<Peer>(), this.config, this.consensusPipeManager, this.syncClientManager);
                        this.stateMachineMap.put(consensusGroupId, consensus);
                        this.checkPeerListAndStartIfEligible(consensusGroupId, consensus);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to recover consensus from {}", (Object)this.storageDir, (Object)e);
                }
            }).exceptionally(e -> {
                LOGGER.error("Failed to recover consensus from {}", (Object)this.storageDir, e);
                return null;
            });
        }
    }

    private void checkPeerListAndStartIfEligible(ConsensusGroupId consensusGroupId, PipeConsensusServerImpl consensus) throws IOException {
        BiConsumer<ConsensusGroupId, List> resetPeerListWithoutThrow = (dataRegionId, peers) -> {
            try {
                this.resetPeerList((ConsensusGroupId)dataRegionId, (List<Peer>)peers);
            }
            catch (ConsensusGroupNotExistException consensusGroupNotExistException) {
            }
            catch (Exception e) {
                LOGGER.warn("Failed to reset peer list while start", (Throwable)e);
            }
        };
        if (this.correctPeerListBeforeStart != null) {
            if (this.correctPeerListBeforeStart.containsKey(consensusGroupId)) {
                resetPeerListWithoutThrow.accept(consensusGroupId, this.correctPeerListBeforeStart.get(consensusGroupId));
                consensus.start(true);
            } else {
                resetPeerListWithoutThrow.accept(consensusGroupId, Collections.emptyList());
            }
        } else {
            consensus.start(true);
        }
    }

    @Override
    public synchronized void stop() {
        this.asyncClientManager.close();
        this.syncClientManager.close();
        this.registerManager.deregisterAll();
        this.consensusPipeGuardian.stop();
        this.stateMachineMap.values().parallelStream().forEach(PipeConsensusServerImpl::stop);
    }

    private void checkAllConsensusPipe() {
        Map<ConsensusGroupId, Map<ConsensusPipeName, PipeStatus>> existedPipes = this.consensusPipeManager.getAllConsensusPipe().entrySet().stream().filter(entry -> ((ConsensusPipeName)entry.getKey()).getSenderDataNodeId() == this.thisNodeId).collect(Collectors.groupingBy(entry -> ((ConsensusPipeName)entry.getKey()).getConsensusGroupId(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        try {
            this.stateMachineMapLock.lock();
            this.stateMachineMap.forEach((key, value) -> value.checkConsensusPipe((Map)existedPipes.getOrDefault(key, (Map<ConsensusPipeName, PipeStatus>)ImmutableMap.of())));
            existedPipes.entrySet().stream().filter(entry -> !this.stateMachineMap.containsKey(entry.getKey())).flatMap(entry -> ((Map)entry.getValue()).keySet().stream()).forEach(consensusPipeName -> {
                try {
                    LOGGER.warn("{} drop consensus pipe [{}]", (Object)consensusPipeName.getConsensusGroupId(), consensusPipeName);
                    this.consensusPipeManager.updateConsensusPipe((ConsensusPipeName)consensusPipeName, PipeStatus.DROPPED);
                }
                catch (Exception e) {
                    LOGGER.warn("{} cannot drop consensus pipe [{}]", new Object[]{consensusPipeName.getConsensusGroupId(), consensusPipeName, e});
                }
            });
        }
        finally {
            this.stateMachineMapLock.unlock();
        }
    }

    @Override
    public TSStatus write(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (impl.isReadOnly()) {
            return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
        }
        if (!impl.isActive()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT, (String)"peer is inactive and not ready to receive sync log request.");
        }
        return impl.write(request);
    }

    @Override
    public DataSet read(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        return Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId)).read(request);
    }

    private String getPeerDir(ConsensusGroupId groupId) {
        return this.storageDir + File.separator + groupId.getType().getValue() + "_" + groupId.getId();
    }

    private ConsensusGroupId parsePeerFileName(String fileName) {
        String[] items = fileName.split("_");
        return ConsensusGroupId.Factory.create((int)Integer.parseInt(items[0]), (int)Integer.parseInt(items[1]));
    }

    @Override
    public void createLocalPeer(ConsensusGroupId groupId, List<Peer> peers) throws ConsensusException {
        int consensusGroupSize = peers.size();
        if (consensusGroupSize == 0) {
            throw new IllegalPeerNumException(consensusGroupSize);
        }
        if (!peers.contains(new Peer(groupId, this.thisNodeId, this.thisNode))) {
            throw new IllegalPeerEndpointException(this.thisNode, peers);
        }
        if (this.stateMachineMap.containsKey(groupId)) {
            throw new ConsensusGroupAlreadyExistException(groupId);
        }
        try {
            this.stateMachineMapLock.lock();
            String path = this.getPeerDir(groupId);
            if (!new File(path).mkdirs()) {
                LOGGER.warn("Unable to create consensus dir for group {} at {}", (Object)groupId, (Object)path);
                throw new ConsensusException(String.format("Unable to create consensus dir for group %s", groupId));
            }
            PipeConsensusServerImpl consensus = new PipeConsensusServerImpl(new Peer(groupId, this.thisNodeId, this.thisNode), (IStateMachine)this.registry.apply(groupId), path, peers, this.config, this.consensusPipeManager, this.syncClientManager);
            this.stateMachineMap.put(groupId, consensus);
            consensus.start(false);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create local peer for group {} with peers {}", new Object[]{groupId, peers, e});
            throw new ConsensusException(e);
        }
        finally {
            this.stateMachineMapLock.unlock();
        }
    }

    @Override
    public void deleteLocalPeer(ConsensusGroupId groupId) throws ConsensusException {
        if (!this.stateMachineMap.containsKey(groupId)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        try {
            this.stateMachineMapLock.lock();
            PipeConsensusServerImpl consensus = this.stateMachineMap.get(groupId);
            consensus.clear();
            FileUtils.deleteFileOrDirectory((File)new File(this.getPeerDir(groupId)));
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete local peer for group {}", (Object)groupId, (Object)e);
            throw new ConsensusException(e);
        }
        finally {
            this.stateMachineMapLock.unlock();
        }
    }

    @Override
    public void addRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (impl.containsPeer(peer)) {
            throw new PeerAlreadyInConsensusGroupException(groupId, peer);
        }
        try {
            LOGGER.info("[{}] inactivate new peer: {}", (Object)CLASS_NAME, (Object)peer);
            impl.setRemotePeerActive(peer, false);
            LOGGER.info("[{}] notify current peers to create consensus pipes...", (Object)CLASS_NAME);
            impl.notifyPeersToCreateConsensusPipes(peer);
            LOGGER.info("[{}] wait until all the other peers finish transferring...", (Object)CLASS_NAME);
            impl.waitPeersToTargetPeerTransmissionCompleted(peer);
            LOGGER.info("[{}] activate new peer...", (Object)CLASS_NAME);
            impl.setRemotePeerActive(peer, true);
        }
        catch (ConsensusGroupModifyPeerException e) {
            try {
                LOGGER.info("[{}] add remote peer failed, automatic cleanup side effects...", (Object)CLASS_NAME);
                impl.notifyPeersToDropConsensusPipe(peer);
            }
            catch (ConsensusGroupModifyPeerException mpe) {
                LOGGER.error("[{}] failed to cleanup side effects after failed to add remote peer", (Object)CLASS_NAME, (Object)mpe);
            }
            throw new ConsensusException(e);
        }
    }

    @Override
    public void removeRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (!impl.containsPeer(peer)) {
            throw new PeerNotInConsensusGroupException(groupId, peer.toString());
        }
        try {
            impl.notifyPeersToDropConsensusPipe(peer);
            impl.setRemotePeerActive(peer, false);
            impl.waitTargetPeerToPeersTransmissionCompleted(peer);
        }
        catch (ConsensusGroupModifyPeerException e) {
            throw new ConsensusException(e.getMessage());
        }
    }

    @Override
    public void recordCorrectPeerListBeforeStarting(Map<ConsensusGroupId, List<Peer>> correctPeerList) {
        LOGGER.info("Record correct peer list: {}", correctPeerList);
        this.correctPeerListBeforeStart = correctPeerList;
    }

    @Override
    public void resetPeerList(ConsensusGroupId groupId, List<Peer> correctPeers) throws ConsensusException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.stateMachineMap.get(groupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        if (!correctPeers.contains(new Peer(groupId, this.thisNodeId, this.thisNode))) {
            LOGGER.warn("[RESET PEER LIST] Local peer is not in the correct configuration, delete local peer {}", (Object)groupId);
            this.deleteLocalPeer(groupId);
            return;
        }
        ImmutableList currentPeers = ImmutableList.copyOf(impl.getPeers());
        String previousPeerListStr = impl.getPeers().toString();
        for (Peer peer : currentPeers) {
            if (correctPeers.contains(peer)) continue;
            try {
                impl.dropConsensusPipeToTargetPeer(peer);
                LOGGER.info("[RESET PEER LIST] Remove sync channel with: {}", (Object)peer);
            }
            catch (ConsensusGroupModifyPeerException e) {
                LOGGER.error("[RESET PEER LIST] Failed to remove sync channel with: {}", (Object)peer, (Object)e);
            }
        }
        for (Peer peer : correctPeers) {
            if (impl.containsPeer(peer) || peer.getNodeId() == this.thisNodeId) continue;
            try {
                impl.createConsensusPipeToTargetPeer(peer);
                LOGGER.info("[RESET PEER LIST] Build sync channel with: {}", (Object)peer);
            }
            catch (ConsensusGroupModifyPeerException e) {
                LOGGER.warn("[RESET PEER LIST] Failed to build sync channel with: {}", (Object)peer, (Object)e);
            }
        }
        String currentPeerListStr = impl.getPeers().toString();
        if (!previousPeerListStr.equals(currentPeerListStr)) {
            LOGGER.info("[RESET PEER LIST] Local peer list has been reset: {} -> {}", (Object)previousPeerListStr, impl.getPeers());
        } else {
            LOGGER.info("[RESET PEER LIST] The current peer list is correct, nothing need to be reset: {}", (Object)previousPeerListStr);
        }
    }

    @Override
    public void transferLeader(ConsensusGroupId groupId, Peer newLeader) throws ConsensusException {
        throw new ConsensusException(String.format("%s does not support leader transfer", CLASS_NAME));
    }

    @Override
    public void triggerSnapshot(ConsensusGroupId groupId, boolean force) throws ConsensusException {
        if (!this.stateMachineMap.containsKey(groupId)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public long getLogicalClock(ConsensusGroupId groupId) {
        return 0L;
    }

    @Override
    public boolean isLeaderReady(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        if (!this.stateMachineMap.containsKey(groupId)) {
            return null;
        }
        return new Peer(groupId, this.thisNodeId, this.thisNode);
    }

    @Override
    public int getReplicationNum(ConsensusGroupId groupId) {
        PipeConsensusServerImpl impl = this.stateMachineMap.get(groupId);
        return impl != null ? impl.getPeers().size() : 0;
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        return new ArrayList<ConsensusGroupId>(this.stateMachineMap.keySet());
    }

    @Override
    public String getRegionDirFromConsensusGroupId(ConsensusGroupId groupId) {
        return this.getPeerDir(groupId);
    }

    @Override
    public void reloadConsensusConfig(ConsensusConfig consensusConfig) {
    }

    public PipeConsensusServerImpl getImpl(ConsensusGroupId groupId) {
        return this.stateMachineMap.get(groupId);
    }

    public int getPipeCount() {
        return this.consensusPipeManager.getAllConsensusPipe().size();
    }
}

