/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.annotation;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.spring.annotation.ApolloProcessor;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValue;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinition;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinitionProcessor;
import com.ctrip.framework.apollo.spring.property.SpringValueRegistry;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;

public class SpringValueProcessor
extends ApolloProcessor
implements BeanFactoryPostProcessor,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringValueProcessor.class);
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private BeanFactory beanFactory;
    private Multimap<String, SpringValueDefinition> beanName2SpringValueDefinitions = LinkedListMultimap.create();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled() && beanFactory instanceof BeanDefinitionRegistry) {
            this.beanName2SpringValueDefinitions = SpringValueDefinitionProcessor.getBeanName2SpringValueDefinitions((BeanDefinitionRegistry)beanFactory);
        }
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            super.postProcessBeforeInitialization(bean, beanName);
            this.processBeanPropertyValues(bean, beanName);
        }
        return bean;
    }

    @Override
    protected void processField(Object bean, String beanName, Field field) {
        Value value = field.getAnnotation(Value.class);
        if (value == null) {
            return;
        }
        this.doRegister(bean, beanName, field, value);
    }

    @Override
    protected void processMethod(Object bean, String beanName, Method method) {
        Value value = method.getAnnotation(Value.class);
        if (value == null) {
            return;
        }
        if (method.getAnnotation(Bean.class) != null) {
            return;
        }
        if (method.getParameterTypes().length != 1) {
            logger.error("Ignore @Value setter {}.{}, expecting 1 parameter, actual {} parameters", new Object[]{bean.getClass().getName(), method.getName(), method.getParameterTypes().length});
            return;
        }
        this.doRegister(bean, beanName, method, value);
    }

    private void doRegister(Object bean, String beanName, Member member, Value value) {
        Set<String> keys = this.placeholderHelper.extractPlaceholderKeys(value.value());
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            SpringValue springValue;
            if (member instanceof Field) {
                Field field = (Field)member;
                springValue = new SpringValue(key, value.value(), bean, beanName, field, false);
            } else if (member instanceof Method) {
                Method method = (Method)member;
                springValue = new SpringValue(key, value.value(), bean, beanName, method, false);
            } else {
                logger.error("Apollo @Value annotation currently only support to be used on methods and fields, but is used on {}", member.getClass());
                return;
            }
            this.springValueRegistry.register(this.beanFactory, key, springValue);
            logger.info("Monitoring {}", (Object)springValue);
        }
    }

    private void processBeanPropertyValues(Object bean, String beanName) {
        Collection propertySpringValues = this.beanName2SpringValueDefinitions.get((Object)beanName);
        if (propertySpringValues == null || propertySpringValues.isEmpty()) {
            return;
        }
        for (SpringValueDefinition definition : propertySpringValues) {
            try {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)definition.getPropertyName());
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                SpringValue springValue = new SpringValue(definition.getKey(), definition.getPlaceholder(), bean, beanName, method, false);
                this.springValueRegistry.register(this.beanFactory, definition.getKey(), springValue);
                logger.debug("Monitoring {}", (Object)springValue);
            }
            catch (Throwable ex) {
                logger.error("Failed to enable auto update feature for {}.{}", bean.getClass(), (Object)definition.getPropertyName());
            }
        }
        this.beanName2SpringValueDefinitions.removeAll((Object)beanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

