/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionException;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;

public abstract class AbstractCompressionCodec
implements CompressionCodec {
    protected abstract byte[] doCompress(byte[] var1) throws IOException;

    public final byte[] compress(byte[] payload) {
        Assert.notNull((Object)payload, (String)"payload cannot be null.");
        try {
            return this.doCompress(payload);
        }
        catch (IOException e) {
            throw new CompressionException("Unable to compress payload.", (Throwable)e);
        }
    }

    public final byte[] decompress(byte[] compressed) {
        Assert.notNull((Object)compressed, (String)"compressed bytes cannot be null.");
        try {
            return this.doDecompress(compressed);
        }
        catch (IOException e) {
            throw new CompressionException("Unable to decompress bytes.", (Throwable)e);
        }
    }

    protected abstract byte[] doDecompress(byte[] var1) throws IOException;
}

