/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.lang.reflect.Array;
import org.apache.seata.common.util.CycleDependencyHandler;
import org.apache.seata.common.util.StringUtils;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static Object[] toArray(Object arrayObj) {
        if (arrayObj == null) {
            return null;
        }
        if (!arrayObj.getClass().isArray()) {
            throw new ClassCastException("'arrayObj' is not an array, can't cast to Object[]");
        }
        int length = Array.getLength(arrayObj);
        Object[] array = new Object[length];
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                array[i] = Array.get(arrayObj, i);
            }
        }
        return array;
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        return CycleDependencyHandler.wrap(array, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[");
            for (Object obj : array) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (obj == array) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(obj));
            }
            sb.append("]");
            return sb.toString();
        });
    }

    public static String toString(Object arrayObj) {
        if (arrayObj == null) {
            return "null";
        }
        if (!arrayObj.getClass().isArray()) {
            return StringUtils.toString(arrayObj);
        }
        if (Array.getLength(arrayObj) == 0) {
            return "[]";
        }
        if (arrayObj.getClass().getComponentType().isPrimitive()) {
            return ArrayUtils.toString(ArrayUtils.toArray(arrayObj));
        }
        return ArrayUtils.toString((Object[])arrayObj);
    }
}

