/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.visitor;

import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.AnnotationVisitor;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.Attribute;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.ClassVisitor;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.FieldVisitor;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.RecordComponentVisitor;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.jar.asm.TypePath;

public abstract class MetadataAwareClassVisitor
extends ClassVisitor {
    private boolean triggerNestHost = true;
    private boolean triggerPermittedSubclasses = true;
    private boolean triggerOuterClass = true;
    private boolean triggerAttributes = true;
    private boolean triggerRecordComponents = true;

    protected MetadataAwareClassVisitor(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    protected void onNestHost() {
    }

    protected void onAfterPermittedSubclasses() {
    }

    protected void onOuterType() {
    }

    protected void onAfterAttributes() {
    }

    protected void onAfterRecordComponents() {
    }

    private void considerTriggerNestHost() {
        if (this.triggerNestHost) {
            this.triggerNestHost = false;
            this.onNestHost();
        }
    }

    private void considerTriggerOuterClass() {
        if (this.triggerOuterClass) {
            this.triggerOuterClass = false;
            this.onOuterType();
        }
    }

    private void considerTriggerAfterPermittedSubclasses() {
        if (this.triggerPermittedSubclasses) {
            this.triggerPermittedSubclasses = false;
            this.onAfterPermittedSubclasses();
        }
    }

    private void considerTriggerAfterAttributes() {
        if (this.triggerAttributes) {
            this.triggerAttributes = false;
            this.onAfterAttributes();
        }
    }

    private void considerTriggerAfterRecordComponents() {
        if (this.triggerRecordComponents) {
            this.triggerRecordComponents = false;
            this.onAfterRecordComponents();
        }
    }

    public final void visitNestHost(String nestHost) {
        this.triggerNestHost = false;
        this.onVisitNestHost(nestHost);
    }

    protected void onVisitNestHost(String nestHost) {
        super.visitNestHost(nestHost);
    }

    public final void visitPermittedSubclass(String permittedSubclass) {
        this.onVisitPermittedSubclass(permittedSubclass);
    }

    protected void onVisitPermittedSubclass(String permittedSubclass) {
        super.visitPermittedSubclass(permittedSubclass);
    }

    public final void visitOuterClass(String owner, String name, String descriptor) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.triggerOuterClass = false;
        this.onVisitOuterClass(owner, name, descriptor);
    }

    protected void onVisitOuterClass(String owner, String name, String descriptor) {
        super.visitOuterClass(owner, name, descriptor);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitRecordComponent(name, descriptor, signature);
    }

    protected RecordComponentVisitor onVisitRecordComponent(String name, String descriptor, String signature) {
        return super.visitRecordComponent(name, descriptor, signature);
    }

    public final AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        return this.onVisitAnnotation(descriptor, visible);
    }

    protected AnnotationVisitor onVisitAnnotation(String descriptor, boolean visible) {
        return super.visitAnnotation(descriptor, visible);
    }

    public final AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        return this.onVisitTypeAnnotation(typeReference, typePath, descriptor, visible);
    }

    protected AnnotationVisitor onVisitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
        return super.visitTypeAnnotation(typeReference, typePath, descriptor, visible);
    }

    public final void visitAttribute(Attribute attribute) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.onVisitAttribute(attribute);
    }

    protected void onVisitAttribute(Attribute attribute) {
        super.visitAttribute(attribute);
    }

    public final void visitNestMember(String nestMember) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitNestMember(nestMember);
    }

    protected void onVisitNestMember(String nestMember) {
        super.visitNestMember(nestMember);
    }

    public final void visitInnerClass(String name, String outerName, String innerName, int modifiers) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitInnerClass(name, outerName, innerName, modifiers);
    }

    protected void onVisitInnerClass(String name, String outerName, String innerName, int modifiers) {
        super.visitInnerClass(name, outerName, innerName, modifiers);
    }

    public final FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object defaultValue) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.considerTriggerAfterRecordComponents();
        return this.onVisitField(modifiers, internalName, descriptor, signature, defaultValue);
    }

    protected FieldVisitor onVisitField(int modifiers, String internalName, String descriptor, String signature, Object defaultValue) {
        return super.visitField(modifiers, internalName, descriptor, signature, defaultValue);
    }

    public final MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.considerTriggerAfterRecordComponents();
        return this.onVisitMethod(modifiers, internalName, descriptor, signature, exception);
    }

    protected MethodVisitor onVisitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
        return super.visitMethod(modifiers, internalName, descriptor, signature, exception);
    }

    public final void visitEnd() {
        this.considerTriggerNestHost();
        this.considerTriggerAfterPermittedSubclasses();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.considerTriggerAfterRecordComponents();
        this.onVisitEnd();
    }

    protected void onVisitEnd() {
        super.visitEnd();
    }
}

