/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.status;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum ExceptionCheckContext {
    INSTANCE;

    private final Set<Class<? extends Throwable>> ignoredExceptions = ConcurrentHashMap.newKeySet(32);
    private final Set<Class<? extends Throwable>> errorStatusExceptions = ConcurrentHashMap.newKeySet(128);

    public boolean isChecked(Throwable throwable) {
        return this.ignoredExceptions.contains(throwable.getClass()) || this.errorStatusExceptions.contains(throwable.getClass());
    }

    public boolean isError(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        return this.errorStatusExceptions.contains(clazz) || !this.ignoredExceptions.contains(clazz);
    }

    public void registerIgnoredException(Throwable throwable) {
        this.ignoredExceptions.add(throwable.getClass());
    }

    public void registerErrorStatusException(Throwable throwable) {
        this.errorStatusExceptions.add(throwable.getClass());
    }
}

