/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowSet;
import dm.jdbc.driver.Row;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class DmdbRowSetWriter
implements RowSetWriter {
    private StringBuffer m_updateCommand = null;
    private StringBuffer m_insertCommand = null;
    private StringBuffer m_deleteCommand = null;
    private int m_columnCount = 0;
    private String m_tabName = "";
    private DmdbResultSetMetaData m_rsmd = null;
    private DmdbPreparedStatement m_updateStmt = null;
    private DmdbPreparedStatement m_insertStmt = null;
    private DmdbPreparedStatement m_deleteStmt = null;
    private DmdbConnection m_conn = null;

    private void initialize(DmdbRowSet dmdbRowSet) {
        this.m_rsmd = (DmdbResultSetMetaData)dmdbRowSet.getMetaData();
        this.m_columnCount = this.m_rsmd.do_getColumnCount();
        this.m_conn = dmdbRowSet.getConnection();
        this.m_tabName = dmdbRowSet.getTableName().toUpperCase();
        this.m_updateCommand = new StringBuffer("UPDATE " + this.m_tabName + " SET ");
        this.m_insertCommand = new StringBuffer("INSERT INTO " + this.m_tabName + "(");
        this.m_deleteCommand = new StringBuffer("DELETE FROM " + this.m_tabName + " WHERE ");
        int n2 = 0;
        while (n2 < this.m_columnCount) {
            if (n2 > 0) {
                this.m_updateCommand.append(" , ");
                this.m_insertCommand.append(" , ");
            }
            this.m_updateCommand.append(this.m_rsmd.do_getColumnName(n2 + 1)).append(" = ?");
            this.m_insertCommand.append(this.m_rsmd.do_getColumnName(n2 + 1));
            ++n2;
        }
        this.m_insertCommand.append(") VALUES(");
        this.m_updateCommand.append(" WHERE ");
        n2 = 0;
        while (n2 < this.m_columnCount) {
            if (n2 > 0) {
                this.m_insertCommand.append(",");
                this.m_updateCommand.append(" AND ");
                this.m_deleteCommand.append(" AND ");
            }
            this.m_insertCommand.append("?");
            this.m_updateCommand.append(this.m_rsmd.do_getColumnName(n2 + 1)).append("= ?");
            this.m_deleteCommand.append(this.m_rsmd.do_getColumnName(n2 + 1)).append("= ?");
            ++n2;
        }
        this.m_insertCommand.append(")");
        this.m_insertStmt = this.m_conn.do_prepareStatement(this.m_insertCommand.substring(0, this.m_insertCommand.length()));
        this.m_updateStmt = this.m_conn.do_prepareStatement(this.m_updateCommand.substring(0, this.m_updateCommand.length()));
        this.m_deleteStmt = this.m_conn.do_prepareStatement(this.m_deleteCommand.substring(0, this.m_deleteCommand.length()));
    }

    private boolean insertRow(Row row) {
        this.m_insertStmt.do_clearParameters();
        int n2 = 0;
        while (n2 < this.m_columnCount) {
            Object object = row.getColumn(n2);
            if (object == null) {
                this.m_insertStmt.do_setNull(n2 + 1, this.m_rsmd.do_getColumnType(n2 + 1));
            } else {
                this.m_insertStmt.do_setObject(n2 + 1, object);
            }
            ++n2;
        }
        return 1 == this.m_insertStmt.do_executeUpdate();
    }

    private boolean updateRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.updateWithNull(row);
        }
        return this.updateNonNull(row);
    }

    private boolean updateWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.m_tabName + " SET ");
        StringBuffer stringBuffer2 = new StringBuffer(" WHERE ");
        int[] nArray = new int[this.m_columnCount];
        int n2 = this.m_columnCount;
        int n3 = 0;
        while (n3 < this.m_columnCount) {
            if (n3 > 0) {
                stringBuffer.append(" , ");
                stringBuffer2.append(" AND ");
            }
            stringBuffer.append(this.m_rsmd.do_getColumnName(n3 + 1)).append(" = ?");
            stringBuffer2.append(this.m_rsmd.do_getColumnName(n3 + 1));
            if (row.isOriginalNull(n3)) {
                nArray[n3] = -1;
                stringBuffer2.append(" IS NULL ");
            } else {
                nArray[n3] = ++n2;
                stringBuffer2.append(" = ? ");
            }
            ++n3;
        }
        stringBuffer.append(stringBuffer2);
        DmdbPreparedStatement dmdbPreparedStatement = this.m_conn.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.m_columnCount) {
            Object object;
            Object object2 = row.getColumn(n4);
            Object object3 = object = row.isColumnChanged(n4) ? row.getChangedColumn(n4) : object2;
            if (object == null) {
                dmdbPreparedStatement.do_setNull(n4 + 1, this.m_rsmd.do_getColumnType(n4 + 1));
            } else {
                dmdbPreparedStatement.do_setObject(n4 + 1, object);
            }
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], object2);
            }
            ++n4;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        stringBuffer = null;
        stringBuffer2 = null;
        return n4 != 0;
    }

    private boolean updateNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.m_columnCount) {
            Object object;
            Object object2 = row.getColumn(n2);
            Object object3 = object = row.isColumnChanged(n2) ? row.getChangedColumn(n2) : object2;
            if (object == null) {
                this.m_updateStmt.do_setNull(n2 + 1, this.m_rsmd.do_getColumnType(n2 + 1));
            } else {
                this.m_updateStmt.do_setObject(n2 + 1, object);
            }
            this.m_updateStmt.do_setObject(this.m_columnCount + n2 + 1, object2);
            ++n2;
        }
        return 1 == this.m_updateStmt.do_executeUpdate();
    }

    private boolean deleteRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.deleteWithNull(row);
        }
        return this.deleteNonNull(row);
    }

    private boolean deleteWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.m_tabName + " WHERE ");
        int[] nArray = new int[this.m_columnCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_columnCount) {
            if (n3 > 0) {
                stringBuffer.append(" AND ");
            }
            if (row.isOriginalNull(n3)) {
                stringBuffer.append(this.m_rsmd.do_getColumnName(n3 + 1)).append(" IS NULL ");
                nArray[n3] = -1;
            } else {
                stringBuffer.append(this.m_rsmd.do_getColumnName(n3 + 1)).append(" = ? ");
                nArray[n3] = ++n2;
            }
            ++n3;
        }
        DmdbPreparedStatement dmdbPreparedStatement = this.m_conn.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.m_columnCount) {
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], row.getColumn(n4));
            }
            n4 += 1;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        dmdbPreparedStatement = null;
        stringBuffer = null;
        return n4 != 0;
    }

    private boolean deleteNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.m_columnCount) {
            this.m_deleteStmt.do_setObject(n2 + 1, row.getColumn(n2));
            ++n2;
        }
        return 1 == this.m_deleteStmt.do_executeUpdate();
    }

    private void release() {
        this.m_insertCommand = null;
        if (this.m_insertStmt != null && !this.m_insertStmt.closed) {
            this.m_insertStmt.do_close();
            this.m_insertStmt = null;
        }
        this.m_updateCommand = null;
        if (this.m_updateStmt != null && !this.m_updateStmt.closed) {
            this.m_updateStmt.do_close();
            this.m_updateStmt = null;
        }
        this.m_deleteCommand = null;
        if (this.m_deleteStmt != null && !this.m_deleteStmt.closed) {
            this.m_deleteStmt.do_close();
            this.m_deleteStmt = null;
        }
        this.m_columnCount = 0;
        this.m_rsmd = null;
        this.m_tabName = "";
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) {
        DmdbRowSet dmdbRowSet = (DmdbRowSet)rowSetInternal;
        this.initialize(dmdbRowSet);
        if (this.m_columnCount < 1) {
            this.release();
            return true;
        }
        boolean bl = dmdbRowSet.getShowDeleted();
        if (this.m_conn.do_getAutoCommit()) {
            this.m_conn.do_setAutoCommit(false);
        }
        dmdbRowSet.setShowDeleted(true);
        dmdbRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        while (dmdbRowSet.next()) {
            Row row;
            if (dmdbRowSet.rowInserted()) {
                if (dmdbRowSet.rowDeleted()) continue;
                row = dmdbRowSet.getCurrentRow();
                bl2 = this.insertRow(row) && bl2;
                continue;
            }
            if (dmdbRowSet.rowUpdated()) {
                row = dmdbRowSet.getCurrentRow();
                bl3 = this.updateRow(row) && bl3;
                continue;
            }
            if (!dmdbRowSet.rowDeleted()) continue;
            row = dmdbRowSet.getCurrentRow();
            boolean bl5 = bl4 = this.deleteRow(row) && bl4;
        }
        if (!(bl2 && bl3 && bl4)) {
            this.m_conn.do_rollback();
        } else {
            this.m_conn.do_commit();
            dmdbRowSet.setOriginal();
        }
        dmdbRowSet.setShowDeleted(bl);
        this.release();
        if (!dmdbRowSet.keepConnecting() && this.m_conn != null && !this.m_conn.do_isClosed()) {
            this.m_conn.do_close();
            this.m_conn = null;
        }
        return true;
    }
}

