/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.AbstractLifeCycle;
import com.alipay.remoting.ConnectionManager;
import com.alipay.remoting.LifeCycleException;
import com.alipay.remoting.Reconnector;
import com.alipay.remoting.Url;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;

public class ReconnectManager
extends AbstractLifeCycle
implements Reconnector {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private static final int HEAL_CONNECTION_INTERVAL = 1000;
    private final ConnectionManager connectionManager;
    private final LinkedBlockingQueue<ReconnectTask> tasks;
    private final List<Url> canceled;
    private Thread healConnectionThreads;

    public ReconnectManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.tasks = new LinkedBlockingQueue();
        this.canceled = new CopyOnWriteArrayList<Url>();
        this.startup();
    }

    @Override
    public void reconnect(Url url) {
        this.ensureStarted();
        this.tasks.add(new ReconnectTask(url));
    }

    @Override
    public void disableReconnect(Url url) {
        this.ensureStarted();
        this.canceled.add(url);
    }

    @Override
    public void enableReconnect(Url url) {
        this.ensureStarted();
        this.canceled.remove(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() throws LifeCycleException {
        ReconnectManager reconnectManager = this;
        synchronized (reconnectManager) {
            if (!this.isStarted()) {
                super.startup();
                this.healConnectionThreads = new Thread(new HealConnectionRunner());
                this.healConnectionThreads.setName("Bolt-heal-connection-thread");
                this.healConnectionThreads.start();
            }
        }
    }

    @Override
    public void shutdown() throws LifeCycleException {
        super.shutdown();
        this.healConnectionThreads.interrupt();
        this.tasks.clear();
        this.canceled.clear();
    }

    @Deprecated
    public void addCancelUrl(Url url) {
        this.ensureStarted();
        this.disableReconnect(url);
    }

    @Deprecated
    public void removeCancelUrl(Url url) {
        this.ensureStarted();
        this.enableReconnect(url);
    }

    @Deprecated
    public void addReconnectTask(Url url) {
        this.ensureStarted();
        this.reconnect(url);
    }

    @Deprecated
    public void stop() {
        this.shutdown();
    }

    private class ReconnectTask
    implements Runnable {
        Url url;

        public ReconnectTask(Url url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                ReconnectManager.this.connectionManager.createConnectionAndHealIfNeed(this.url);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class HealConnectionRunner
    implements Runnable {
        private long lastConnectTime = -1L;

        private HealConnectionRunner() {
        }

        @Override
        public void run() {
            while (ReconnectManager.this.isStarted()) {
                long start = -1L;
                ReconnectTask task = null;
                try {
                    if (this.lastConnectTime < 1000L) {
                        Thread.sleep(1000L);
                    }
                    try {
                        task = (ReconnectTask)ReconnectManager.this.tasks.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (task == null) continue;
                    start = System.currentTimeMillis();
                    if (!ReconnectManager.this.canceled.contains(task.url)) {
                        task.run();
                    } else {
                        logger.warn("Invalid reconnect request task {}, cancel list size {}", (Object)task.url, (Object)ReconnectManager.this.canceled.size());
                    }
                    this.lastConnectTime = System.currentTimeMillis() - start;
                }
                catch (Exception e) {
                    if (start != -1L) {
                        this.lastConnectTime = System.currentTimeMillis() - start;
                    }
                    if (task == null) continue;
                    logger.warn("reconnect target: {} failed.", (Object)task.url, (Object)e);
                    ReconnectManager.this.tasks.add(task);
                }
            }
        }
    }
}

