/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.core.rate.limit.TimeWindow;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;

final class SmoothWindow
implements TimeWindow {
    private final RunningStopwatch stopwatch;
    private final int maxInvocations;
    private final long minSpacingInMillis;
    private final double refreshPermitsPerMillis;
    private final double millisToRefreshOnePermit;
    private double currentPermits;
    private long lastInvocation;
    private long lastPermitRefresh;

    SmoothWindow(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        this.stopwatch = stopwatch.start();
        this.refreshPermitsPerMillis = (double)maxInvocations / (double)timeWindowInMillis;
        this.millisToRefreshOnePermit = (double)timeWindowInMillis / (double)maxInvocations;
        this.maxInvocations = maxInvocations;
        this.minSpacingInMillis = minSpacingInMillis;
        this.currentPermits = 1.0;
        this.lastInvocation = -minSpacingInMillis;
        this.lastPermitRefresh = 0L;
    }

    @Override
    public synchronized long record() {
        long timeFromPrevious;
        long result;
        long now = this.stopwatch.elapsedTimeInMillis();
        double permitsToRefresh = (double)(now - this.lastPermitRefresh) * this.refreshPermitsPerMillis;
        if (permitsToRefresh > 0.01) {
            this.currentPermits = Math.min(this.currentPermits + permitsToRefresh, (double)this.maxInvocations);
            this.lastPermitRefresh = now;
        }
        long l = result = this.currentPermits >= 1.0 ? 0L : Math.round((1.0 - this.currentPermits) * this.millisToRefreshOnePermit);
        if (result == 0L && this.minSpacingInMillis != 0L && (timeFromPrevious = now - this.lastInvocation) < this.minSpacingInMillis) {
            result = this.minSpacingInMillis - timeFromPrevious;
        }
        if (result == 0L) {
            this.currentPermits -= 1.0;
        }
        this.lastInvocation = now;
        return result;
    }
}

