/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.exception;

import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.core.exceptions.AlreadyExistsException;
import org.apache.polaris.core.exceptions.CommitConflictException;
import org.apache.polaris.core.exceptions.PolarisException;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.policy.exceptions.NoSuchPolicyException;
import org.apache.polaris.core.policy.exceptions.PolicyAttachException;
import org.apache.polaris.core.policy.exceptions.PolicyInUseException;
import org.apache.polaris.core.policy.exceptions.PolicyVersionMismatchException;
import org.apache.polaris.core.policy.validator.InvalidPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Provider
public class PolarisExceptionMapper
implements ExceptionMapper<PolarisException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisExceptionMapper.class);

    private Response.Status getStatus(PolarisException exception) {
        PolarisException polarisException = exception;
        Objects.requireNonNull(polarisException);
        PolarisException polarisException2 = polarisException;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlreadyExistsException.class, CommitConflictException.class, InvalidPolicyException.class, PolicyAttachException.class, NoSuchPolicyException.class, PolicyVersionMismatchException.class, PolicyMappingAlreadyExistsException.class, PolicyInUseException.class}, (Object)polarisException2, n)) {
            case 0 -> {
                AlreadyExistsException alreadyExistsException = (AlreadyExistsException)polarisException2;
                yield Response.Status.CONFLICT;
            }
            case 1 -> {
                CommitConflictException commitConflictException = (CommitConflictException)polarisException2;
                yield Response.Status.CONFLICT;
            }
            case 2 -> {
                InvalidPolicyException invalidPolicyException = (InvalidPolicyException)polarisException2;
                yield Response.Status.BAD_REQUEST;
            }
            case 3 -> {
                PolicyAttachException policyAttachException = (PolicyAttachException)polarisException2;
                yield Response.Status.BAD_REQUEST;
            }
            case 4 -> {
                NoSuchPolicyException noSuchPolicyException = (NoSuchPolicyException)polarisException2;
                yield Response.Status.NOT_FOUND;
            }
            case 5 -> {
                PolicyVersionMismatchException policyVersionMismatchException = (PolicyVersionMismatchException)polarisException2;
                yield Response.Status.CONFLICT;
            }
            case 6 -> {
                PolicyMappingAlreadyExistsException policyMappingAlreadyExistsException = (PolicyMappingAlreadyExistsException)polarisException2;
                yield Response.Status.CONFLICT;
            }
            case 7 -> {
                PolicyInUseException policyInUseException = (PolicyInUseException)polarisException2;
                yield Response.Status.BAD_REQUEST;
            }
            default -> Response.Status.INTERNAL_SERVER_ERROR;
        };
    }

    public Response toResponse(PolarisException exception) {
        Response.Status status = this.getStatus(exception);
        this.getLogger().atLevel(status.getFamily() == Response.Status.Family.SERVER_ERROR ? Level.INFO : Level.DEBUG).log("Full PolarisException", (Object)exception);
        ErrorResponse errorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(status.getStatusCode())).withType(exception.getClass().getSimpleName()).withMessage(exception.getMessage()).build();
        return Response.status((Response.Status)status).entity((Object)errorResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @VisibleForTesting
    Logger getLogger() {
        return LOGGER;
    }
}

