/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.IcebergRestCatalogApiService;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalogAdapter;
import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.polaris.service.types.NotificationRequest;

@Decorator
@Priority(value=1000)
public class IcebergRestCatalogEventServiceDelegator
implements IcebergRestCatalogApiService {
    @Inject
    @Delegate
    IcebergCatalogAdapter delegate;

    public Response createNamespace(String prefix, CreateNamespaceRequest createNamespaceRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.createNamespace(prefix, createNamespaceRequest, realmContext, securityContext);
    }

    public Response listNamespaces(String prefix, String pageToken, Integer pageSize, String parent, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listNamespaces(prefix, pageToken, pageSize, parent, realmContext, securityContext);
    }

    public Response loadNamespaceMetadata(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.loadNamespaceMetadata(prefix, namespace, realmContext, securityContext);
    }

    public Response namespaceExists(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.namespaceExists(prefix, namespace, realmContext, securityContext);
    }

    public Response dropNamespace(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.dropNamespace(prefix, namespace, realmContext, securityContext);
    }

    public Response updateProperties(String prefix, String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.updateProperties(prefix, namespace, updateNamespacePropertiesRequest, realmContext, securityContext);
    }

    public Response createTable(String prefix, String namespace, CreateTableRequest createTableRequest, String accessDelegationMode, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.createTable(prefix, namespace, createTableRequest, accessDelegationMode, realmContext, securityContext);
    }

    public Response listTables(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listTables(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
    }

    public Response loadTable(String prefix, String namespace, String table, String accessDelegationMode, String ifNoneMatchString, String snapshots, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.loadTable(prefix, namespace, table, accessDelegationMode, ifNoneMatchString, snapshots, realmContext, securityContext);
    }

    public Response tableExists(String prefix, String namespace, String table, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.tableExists(prefix, namespace, table, realmContext, securityContext);
    }

    public Response dropTable(String prefix, String namespace, String table, Boolean purgeRequested, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.dropTable(prefix, namespace, table, purgeRequested, realmContext, securityContext);
    }

    public Response registerTable(String prefix, String namespace, RegisterTableRequest registerTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.registerTable(prefix, namespace, registerTableRequest, realmContext, securityContext);
    }

    public Response renameTable(String prefix, RenameTableRequest renameTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.renameTable(prefix, renameTableRequest, realmContext, securityContext);
    }

    public Response updateTable(String prefix, String namespace, String table, CommitTableRequest commitTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.updateTable(prefix, namespace, table, commitTableRequest, realmContext, securityContext);
    }

    public Response createView(String prefix, String namespace, CreateViewRequest createViewRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.createView(prefix, namespace, createViewRequest, realmContext, securityContext);
    }

    public Response listViews(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listViews(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
    }

    public Response loadCredentials(String prefix, String namespace, String table, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.loadCredentials(prefix, namespace, table, realmContext, securityContext);
    }

    public Response loadView(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.loadView(prefix, namespace, view, realmContext, securityContext);
    }

    public Response viewExists(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.viewExists(prefix, namespace, view, realmContext, securityContext);
    }

    public Response dropView(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.dropView(prefix, namespace, view, realmContext, securityContext);
    }

    public Response renameView(String prefix, RenameTableRequest renameTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.renameView(prefix, renameTableRequest, realmContext, securityContext);
    }

    public Response replaceView(String prefix, String namespace, String view, CommitViewRequest commitViewRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.replaceView(prefix, namespace, view, commitViewRequest, realmContext, securityContext);
    }

    public Response commitTransaction(String prefix, CommitTransactionRequest commitTransactionRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.commitTransaction(prefix, commitTransactionRequest, realmContext, securityContext);
    }

    public Response reportMetrics(String prefix, String namespace, String table, ReportMetricsRequest reportMetricsRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.reportMetrics(prefix, namespace, table, reportMetricsRequest, realmContext, securityContext);
    }

    public Response sendNotification(String prefix, String namespace, String table, NotificationRequest notificationRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.sendNotification(prefix, namespace, table, notificationRequest, realmContext, securityContext);
    }
}

