/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.external;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.polaris.service.auth.PolarisCredential;
import org.apache.polaris.service.auth.external.mapping.PrincipalMapper;
import org.apache.polaris.service.auth.external.mapping.PrincipalRolesMapper;
import org.apache.polaris.service.auth.external.tenant.OidcTenantConfiguration;
import org.apache.polaris.service.auth.external.tenant.OidcTenantResolvingAugmentor;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class OidcPolarisCredentialAugmentor
implements SecurityIdentityAugmentor {
    public static final int PRIORITY = 1100;
    private final Instance<PrincipalMapper> principalMappers;
    private final Instance<PrincipalRolesMapper> principalRoleMappers;

    @Inject
    public OidcPolarisCredentialAugmentor(@Any Instance<PrincipalMapper> principalMappers, @Any Instance<PrincipalRolesMapper> principalRoleMappers) {
        this.principalMappers = principalMappers;
        this.principalRoleMappers = principalRoleMappers;
    }

    public int priority() {
        return 1100;
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous() || !(identity.getPrincipal() instanceof JsonWebToken)) {
            return Uni.createFrom().item((Object)identity);
        }
        OidcTenantConfiguration config = OidcTenantResolvingAugmentor.getOidcTenantConfig(identity);
        PrincipalMapper principalMapper = (PrincipalMapper)this.principalMappers.select(new Annotation[]{Identifier.Literal.of((String)config.principalMapper().type())}).get();
        PrincipalRolesMapper principalRolesMapper = (PrincipalRolesMapper)this.principalRoleMappers.select(new Annotation[]{Identifier.Literal.of((String)config.principalRolesMapper().type())}).get();
        return context.runBlocking(() -> this.setPolarisCredential(identity, principalMapper, principalRolesMapper));
    }

    protected SecurityIdentity setPolarisCredential(SecurityIdentity identity, PrincipalMapper principalMapper, PrincipalRolesMapper rolesMapper) {
        Long principalId = principalMapper.mapPrincipalId(identity).stream().boxed().findFirst().orElse(null);
        String principalName = principalMapper.mapPrincipalName(identity).orElse(null);
        Set<String> principalRoles = rolesMapper.mapPrincipalRoles(identity);
        PolarisCredential credential = PolarisCredential.of(principalId, principalName, principalRoles);
        return QuarkusSecurityIdentity.builder((SecurityIdentity)identity).addCredential((Credential)credential).build();
    }
}

