/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BasePositionDeletesScanTask;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SnapshotScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.TableUtil;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.TableScanUtil;

public class PositionDeletesTable
extends BaseMetadataTable {
    public static final String PARTITION = "partition";
    public static final String SPEC_ID = "spec_id";
    public static final String DELETE_FILE_PATH = "delete_file_path";
    public static final String CONTENT_OFFSET = "content_offset";
    public static final String CONTENT_SIZE_IN_BYTES = "content_size_in_bytes";
    private final Schema schema = this.calculateSchema();
    private final int defaultSpecId;
    private final Map<Integer, PartitionSpec> specs;

    PositionDeletesTable(Table table) {
        this(table, table.name() + ".position_deletes");
    }

    PositionDeletesTable(Table table, String name) {
        super(table, name);
        this.defaultSpecId = table.spec().specId();
        this.specs = PositionDeletesTable.transformSpecs(this.schema(), table.specs());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.POSITION_DELETES;
    }

    public TableScan newScan() {
        throw new UnsupportedOperationException("Cannot create TableScan from table of type POSITION_DELETES");
    }

    public BatchScan newBatchScan() {
        return new PositionDeletesBatchScan(this.table(), this.schema());
    }

    public Schema schema() {
        return this.schema;
    }

    @Override
    public PartitionSpec spec() {
        return this.specs.get(this.defaultSpecId);
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.specs;
    }

    @Override
    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.table().properties().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("write.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private Schema calculateSchema() {
        int formatVersion = TableUtil.formatVersion(this.table());
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)MetadataColumns.DELETE_FILE_PATH).add((Object)MetadataColumns.DELETE_FILE_POS).add((Object)Types.NestedField.optional((int)2147483544, (String)"row", (Type)this.table().schema().asStruct(), (String)"Deleted row values")).add((Object)Types.NestedField.required((int)0x7FFFFFFA, (String)PARTITION, (Type)partitionType, (String)"Partition that position delete row belongs to")).add((Object)Types.NestedField.required((int)0x7FFFFFFB, (String)SPEC_ID, (Type)Types.IntegerType.get(), (String)"Spec ID used to track the file containing a row")).add((Object)Types.NestedField.required((int)0x7FFFFFFE, (String)DELETE_FILE_PATH, (Type)Types.StringType.get(), (String)"Path of the file in which a row is stored"));
        if (formatVersion >= 3) {
            builder.add((Object)Types.NestedField.optional((int)0x7FFFFFF9, (String)CONTENT_OFFSET, (Type)Types.LongType.get(), (String)"The offset in the DV where the content starts")).add((Object)Types.NestedField.optional((int)0x7FFFFFF8, (String)CONTENT_SIZE_IN_BYTES, (Type)Types.LongType.get(), (String)"The length in bytes of the DV blob"));
        }
        ImmutableList columns = builder.build();
        Set currentlyUsedIds = Collections.unmodifiableSet(TypeUtil.indexById((Types.StructType)Types.StructType.of((List)columns)).keySet());
        Set allUsedIds = this.table().schemas().values().stream().map(currSchema -> TypeUtil.indexById((Types.StructType)currSchema.asStruct()).keySet()).reduce(currentlyUsedIds, Sets::union);
        Set idsToReassign = partitionType.fields().stream().map(Types.NestedField::fieldId).collect(Collectors.toSet());
        AtomicInteger nextId = new AtomicInteger();
        Schema result = new Schema((List)columns, (Set)ImmutableSet.of(), oldId -> {
            if (!idsToReassign.contains(oldId)) {
                return oldId;
            }
            int candidate = nextId.incrementAndGet();
            while (allUsedIds.contains(candidate)) {
                candidate = nextId.incrementAndGet();
            }
            return candidate;
        });
        if (!partitionType.fields().isEmpty()) {
            return result;
        }
        return TypeUtil.selectNot((Schema)result, (Set)Sets.newHashSet((Object[])new Integer[]{0x7FFFFFFA}));
    }

    public static class PositionDeletesBatchScan
    extends SnapshotScan<BatchScan, ScanTask, ScanTaskGroup<ScanTask>>
    implements BatchScan {
        private Expression baseTableFilter = Expressions.alwaysTrue();

        protected PositionDeletesBatchScan(Table table, Schema schema) {
            super(table, schema, TableScanContext.empty());
        }

        protected PositionDeletesBatchScan(Table table, Schema schema, TableScanContext context, Expression baseTableFilter) {
            super(table, schema, context);
            this.baseTableFilter = baseTableFilter;
        }

        @Override
        protected PositionDeletesBatchScan newRefinedScan(Table newTable, Schema newSchema, TableScanContext newContext) {
            return new PositionDeletesBatchScan(newTable, newSchema, newContext, this.baseTableFilter);
        }

        public CloseableIterable<ScanTaskGroup<ScanTask>> planTasks() {
            return TableScanUtil.planTaskGroups(this.planFiles(), this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
        }

        @Override
        protected List<String> scanColumns() {
            return this.context().returnColumnStats() ? DELETE_SCAN_WITH_STATS_COLUMNS : DELETE_SCAN_COLUMNS;
        }

        public BatchScan baseTableFilter(Expression expr) {
            return new PositionDeletesBatchScan(this.table(), this.schema(), this.context(), Expressions.and((Expression)this.baseTableFilter, (Expression)expr));
        }

        @Override
        protected CloseableIterable<ScanTask> doPlanFiles() {
            String schemaString = SchemaParser.toJson(this.tableSchema());
            Map<Integer, PartitionSpec> transformedSpecs = BaseMetadataTable.transformSpecs(this.tableSchema(), this.table().specs());
            LoadingCache<Integer, String> specStringCache = this.partitionCacheOf(transformedSpecs, PartitionSpecParser::toJson);
            LoadingCache<Integer, ManifestEvaluator> deletesTableEvalCache = this.partitionCacheOf(transformedSpecs, spec -> ManifestEvaluator.forRowFilter((Expression)this.filter(), (PartitionSpec)spec, (boolean)this.isCaseSensitive()));
            LoadingCache<Integer, ManifestEvaluator> baseTableEvalCache = this.partitionCacheOf(this.table().specs(), spec -> ManifestEvaluator.forRowFilter((Expression)this.baseTableFilter, (PartitionSpec)spec, (boolean)this.isCaseSensitive()));
            LoadingCache<Integer, ResidualEvaluator> residualCache = this.partitionCacheOf(transformedSpecs, spec -> ResidualEvaluator.of((PartitionSpec)spec, (Expression)(this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter()), (boolean)this.isCaseSensitive()));
            List manifests = this.snapshot().deleteManifests(this.table().io());
            CloseableIterable matchingManifests = CloseableIterable.filter((Counter)this.scanMetrics().skippedDeleteManifests(), (CloseableIterable)CloseableIterable.withNoopClose((Iterable)manifests), manifest -> ((ManifestEvaluator)baseTableEvalCache.get((Object)manifest.partitionSpecId())).eval(manifest) && ((ManifestEvaluator)deletesTableEvalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
            matchingManifests = CloseableIterable.count((Counter)this.scanMetrics().scannedDeleteManifests(), (CloseableIterable)matchingManifests);
            CloseableIterable tasks = CloseableIterable.transform((CloseableIterable)matchingManifests, manifest -> this.posDeletesScanTasks((ManifestFile)manifest, (PartitionSpec)this.table().specs().get(manifest.partitionSpecId()), schemaString, transformedSpecs, residualCache, specStringCache));
            if (this.planExecutor() != null) {
                return new ParallelIterable<ScanTask>((Iterable<Iterable<ScanTask>>)tasks, this.planExecutor());
            }
            return CloseableIterable.concat((Iterable)tasks);
        }

        private CloseableIterable<ScanTask> posDeletesScanTasks(final ManifestFile manifest, final PartitionSpec spec, final String schemaString, final Map<Integer, PartitionSpec> transformedSpecs, final LoadingCache<Integer, ResidualEvaluator> residualCache, final LoadingCache<Integer, String> specStringCache) {
            return new CloseableIterable<ScanTask>(){
                private CloseableIterable<ScanTask> iterable;

                public void close() throws IOException {
                    if (this.iterable != null) {
                        this.iterable.close();
                    }
                }

                public CloseableIterator<ScanTask> iterator() {
                    Expression partitionFilter = Projections.inclusive((PartitionSpec)spec, (boolean)this.isCaseSensitive()).project(baseTableFilter);
                    CloseableIterable<ManifestEntry<DeleteFile>> deleteFileEntries = ManifestFiles.readDeleteManifest(manifest, this.table().io(), transformedSpecs).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterRows(this.filter()).filterPartitions(partitionFilter).scanMetrics(this.scanMetrics()).liveEntries();
                    CloseableIterable positionDeleteEntries = CloseableIterable.filter(deleteFileEntries, entry -> ((DeleteFile)entry.file()).content().equals((Object)FileContent.POSITION_DELETES));
                    this.iterable = CloseableIterable.transform((CloseableIterable)positionDeleteEntries, entry -> {
                        int specId = ((DeleteFile)entry.file()).specId();
                        return new BasePositionDeletesScanTask((DeleteFile)((DeleteFile)entry.file()).copy(this.context().returnColumnStats()), schemaString, (String)specStringCache.get((Object)specId), (ResidualEvaluator)residualCache.get((Object)specId));
                    });
                    return this.iterable.iterator();
                }
            };
        }

        private <T> LoadingCache<Integer, T> partitionCacheOf(Map<Integer, PartitionSpec> specs, Function<PartitionSpec, T> constructor) {
            return Caffeine.newBuilder().build(specId -> {
                PartitionSpec spec = (PartitionSpec)specs.get(specId);
                return constructor.apply(spec);
            });
        }
    }
}

