/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamPrincipal;
import software.amazon.awssdk.policybuilder.iam.IamPrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamPrincipal
implements IamPrincipal {
    @NotNull
    private final IamPrincipalType type;
    @NotNull
    private final String id;

    private DefaultIamPrincipal(Builder builder) {
        this.type = (IamPrincipalType)Validate.paramNotNull((Object)builder.type, (String)"principalType");
        this.id = (String)Validate.paramNotNull((Object)builder.id, (String)"principalId");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public IamPrincipalType type() {
        return this.type;
    }

    @Override
    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIamPrincipal that = (DefaultIamPrincipal)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"IamPrincipal").add("type", (Object)this.type.value()).add("id", (Object)this.id).build();
    }

    public static class Builder
    implements IamPrincipal.Builder {
        private IamPrincipalType type;
        private String id;

        private Builder() {
        }

        private Builder(DefaultIamPrincipal principal) {
            this.type = principal.type;
            this.id = principal.id;
        }

        @Override
        public IamPrincipal.Builder type(IamPrincipalType type) {
            this.type = type;
            return this;
        }

        @Override
        public IamPrincipal.Builder type(String type) {
            this.type = type == null ? null : IamPrincipalType.create(type);
            return this;
        }

        @Override
        public IamPrincipal.Builder id(String id) {
            this.id = id;
            return this;
        }

        public IamPrincipal build() {
            return new DefaultIamPrincipal(this);
        }
    }
}

