<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at
 
   http://www.apache.org/licenses/LICENSE-2.0
 
  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

Links:
* Hugo: https://gohugo.io/
* Docsy theme: https://www.docsy.dev/docs/ and https://github.com/google/docsy/
* Asciidoc help: https://docs.asciidoctor.org/asciidoc/latest/
* Fontawesome logos/icons: https://fontawesome.com/v6/search?o=r&m=free

# Quickstart

Just run the following command to let Hugo serve files from the Polaris `site/`.
```bash
site/bin/run-hugo-in-docker.sh
```

Then point your browser to http://localhost:1313/

Then edit files from your IDE - you will see the changes in your browser. When changing the site structure,
it is often necessary to restart Hugo - just run `site/bin/run-hugo-in-docker.sh` again. 

# Building the static site

## Building a static site - served at http://localhost:8080/

This builds the static Apache Polaris site into `site/build/localhost-site` to be served using a http daemon.
The base URL will be `https://localhost:8080/`, which is the URL to be used when running the command below.
(Note: static sites generated by Hugo do **not** work when opening the files from the local file system!)

Run
```bash
site/bin/create-static-site.sh --local
```

## Building the Apache Polaris site

This builds the static Apache Polaris site into `site/build/apache-site`. The base URL will be
`https://polaris.apache.org/` (as configured in `hugo.yaml`).
(Note: static sites generated by Hugo do **not** work when opening the files from the local file system!)

Run
```bash
site/bin/create-static-site.sh
```

# Versioned docs

(See [`/releases/` page](content/releases/_index.adoc) as well.)

The idea here is that docs of releases live in either a separate branch or a separate Git repo.

The `/releases` folder would _not_ be in the main Polaris repository (at least not in any code branch). It would be
mounted either via `git worktree` or `git clone`. Building and testing the site locally works without the `/releases`
folder. For developers, it is probably much easier to have a separate branch in the main Polaris GitHub repository
and leverage Git worktrees.

Docs for the current code branch (e.g. `main` branch) are maintained in the `/in-dev/unreleased` folder. While we
could maintain the docs right in the `/in-dev` folder, having the in-dev docs in `/in-dev/unreleased` provides the
ability to use relative links that still work when the docs are in an `/releases/x.y.z` folder (think: links like
`../../guides/foo-bar.md`).

Within a release's versioned docs folder, the release version number can be included in the markdown using the
custom Hugo shortcode `{{< releaseVersion >}}`.

## Git worktree

The `content/releases/` folder is maintained in the separate `versioned-docs` branch. The whole `content/releases/`
folder is `.gitignore`d in the main source tree, otherwise Git complains about `content/releases` not being versioned
and if added to the main source tree (possible, Git allows that), the `git worktree add` below would complain about
the existing directory.

### Initial setup

```bash
cd site/

cd content/releases/
# Create a new empty branch 'versioned-docs'
git worktree add --orphan -b versioned-docs .
# (add some content to the content/releases/ directory - at least the "top-level" _index.adoc
git add .
git commit -m "Initial set of releases"
```

### Locally

Use the following script to checkout the versioned release docs
```bash
cd site/
# Checkout the versioned-docs branch locally
bin/checkout-releases.sh
```

`bin/remove-releases.sh` removes the `content/releases` folder, if it does not contain uncommitted changes.

## New release

When a release is created, a bunch of things would happen via an automated GitHub workflow calling a shell script
in the main source tree:

1. The releases versioned docs folder is created - for example: `/releases/0.1.0`
2. The contents of the `/in-dev/unreleased` folder are copied into the directory for the new release.
    1. The file `release_index.md` would be copied as `_index.md` into the new release's
       versioned docs folder, the `/in-dev/unreleased/_index.md` would not end in the release's versioned docs folder.
3. The front-matter of the release's `_index.md` would be rewritten.
4. The new release is added to `params.active_releases` in `hugo.yaml`
5. When publishing a new release for the most recent major/minor version:
    1. The new release's `_index.md` would be generated with `exclude_search: false`
    2. The front-matter of the previous release's `_index.md` would be updated,
       `exclude_search: false` changed to `exclude_search: true`.
6. When publishing a new release for an older major/minor version:
    1. The new release's `_index.md` would be generated with `exclude_search: true`
7. Changes to the site added and committed to Git
8. Changes pushed to GitHub - both the `main` and the `versioned-docs` folder
9. The last step triggers the job to publish the web site

# Web site publishing (production)

To build a site locally (not required for `hugo serve -D`, but required for `hugo`) - with your local user.

This would be a GitHub workflow.

1. Triggered when the `main` branch or the `versioned-docs` branch changes.
2. Checkout the `main` branch
3. ```bash
   cd site/
   ```
4. ```bash
   git worktree add content/releases/ versioned-docs
   ```
5. ```bash
   npm i -D postcss postcss-cli autoprefixer
   ```
6. ```bash
   rm -rf public ; hugo --minify --gc
   ``` 
7. Publish the contents of the `public` folder to the website.

## Test statically built web site locally

The statically built web site in `public` _does not_ work when opened from the file system.

Instead, do something like this:

1. ```bash
   rm -rf public ; hugo --minify --gc --baseURL http://localhost:8080/
   (cd public/ ; http-server -p 8080 --cors)
   ```
2. Then use your web browser to open http://localhost:8080/

# Noteworthy

* The `redoc` shortcode works fine with `hugo serve` and on the static site configured via the `baseURL` in `hugo.yaml`.
  To test the static build result locally, it is mandatory to pass the `--baseURL` option to `hugo`.
* The embedded `redoc` looks awful with a dark theme.
* The `swaggerui` shortcode doesn't seem to work?
* Some changes, especially those that change the site structure, requires a restart of `hugo serve -D`. This is also
  true when the layout for the `robots.txt` is changed.

# Install Hugo + asciidoctor locally

https://gohugo.io/installation/

## Ubuntu

To develop the site locally (aka `hugo serve -D`), install the following dependencies using the `root` user:
```bash
apt install hugo asciidoctor
snap install dart-sass
```

If you want to build the static site locally as well (aka build with `hugo` + serve using another http server),
the following dependencies are needed as well (non-root user):
```bash
npm i -D postcss postcss-cli autoprefixer
npm install http-server -g
```

## macOS

To develop the site locally (aka `hugo serve -D`), install the following dependencies:
```bash
brew install go
brew install hugo
brew install asciidoctor
```

If you want to build the static site locally as well (aka build with `hugo` + serve using another http server),
the following dependencies are needed as well (non-root user):
```bash
brew install npm
npm -i -D postcss postcss-cli autoprefixer
npm install http-server -g
```
