/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.kafka;

import com.xiaomi.youpin.docean.anno.Service;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.parse.LogParserFactory;
import org.apache.ozhera.log.stream.common.SinkJobEnum;
import org.apache.ozhera.log.stream.job.LogDataTransfer;
import org.apache.ozhera.log.stream.job.SinkJobConfig;
import org.apache.ozhera.log.stream.job.extension.MessageSender;
import org.apache.ozhera.log.stream.job.extension.MessageSenderFactory;
import org.apache.ozhera.log.stream.job.extension.SinkJob;
import org.apache.ozhera.log.stream.job.extension.SinkJobProvider;
import org.apache.ozhera.log.stream.job.extension.kafka.KafkaConfig;
import org.apache.ozhera.log.stream.job.extension.kafka.KafkaPlugin;
import org.apache.ozhera.log.stream.job.extension.kafka.KafkaSinkJob;
import org.apache.ozhera.log.stream.sink.SinkChain;

@Service(name="kafkaSinkJobProvider")
public class KafkaSinkJobProvider
implements SinkJobProvider {
    @Override
    public SinkJob getSinkJob(SinkJobConfig sinkJobConfig) {
        SinkJobEnum jobType = SinkJobEnum.valueOf(sinkJobConfig.getJobType());
        MessageSender messageSender = MessageSenderFactory.getMessageSender(sinkJobConfig);
        SinkChain sinkChain = sinkJobConfig.getSinkChain();
        LogParser logParser = LogParserFactory.getLogParser((Integer)sinkJobConfig.getParseType(), (String)sinkJobConfig.getKeyList(), (String)sinkJobConfig.getValueList(), (String)sinkJobConfig.getParseScript(), (String)sinkJobConfig.getTopic(), (String)sinkJobConfig.getTail(), (String)sinkJobConfig.getTag(), (String)sinkJobConfig.getLogStoreName());
        LogDataTransfer dataTransfer = new LogDataTransfer(sinkChain, logParser, messageSender, sinkJobConfig);
        dataTransfer.setJobType(jobType);
        KafkaConfig mqConfig = KafkaPlugin.buildKafkaConfig(sinkJobConfig.getAk(), sinkJobConfig.getSk(), sinkJobConfig.getClusterInfo(), sinkJobConfig.getTopic(), sinkJobConfig.getTag(), sinkJobConfig.getConsumerGroup(), jobType);
        KafkaConsumer<String, String> mqConsumer = KafkaPlugin.getKafkaConsumer(mqConfig);
        KafkaSinkJob sinkJob = new KafkaSinkJob(mqConfig, mqConsumer, dataTransfer);
        return sinkJob;
    }

    @Override
    public SinkJob getBackupJob(SinkJobConfig sinkJobConfig) {
        return null;
    }
}

