/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension;

import com.xiaomi.mone.es.EsProcessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.stream.job.SinkJobConfig;
import org.apache.ozhera.log.stream.job.extension.MessageSender;
import org.apache.ozhera.log.stream.job.extension.MqMessageProduct;
import org.apache.ozhera.log.stream.job.extension.impl.DorisMessageSender;
import org.apache.ozhera.log.stream.job.extension.impl.EsMessageSender;
import org.apache.ozhera.log.stream.job.extension.impl.RocketMqMessageProduct;
import org.apache.ozhera.log.stream.plugin.es.EsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSenderFactory {
    private static final Logger log = LoggerFactory.getLogger(MessageSenderFactory.class);

    public static MessageSender getMessageSender(SinkJobConfig sinkJobConfig) {
        RocketMqMessageProduct mqMessageProduct = new RocketMqMessageProduct();
        String storageType = sinkJobConfig.getStorageType();
        LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)storageType);
        if (null == storageTypeEnum) {
            return MessageSenderFactory.getEsMessageSender(sinkJobConfig, mqMessageProduct);
        }
        switch (storageTypeEnum) {
            case ELASTICSEARCH: {
                return MessageSenderFactory.getEsMessageSender(sinkJobConfig, mqMessageProduct);
            }
            case DORIS: {
                return MessageSenderFactory.getDorisMessageSender(sinkJobConfig, mqMessageProduct);
            }
        }
        return null;
    }

    private static MessageSender getEsMessageSender(SinkJobConfig sinkJobConfig, MqMessageProduct mqMessageProduct) {
        String index = sinkJobConfig.getIndex();
        if (StringUtils.isEmpty((CharSequence)index)) {
            log.error("es index is null,sinkJobConfig:{}", (Object)Constant.GSON.toJson((Object)sinkJobConfig));
            throw new RuntimeException("es index is null");
        }
        EsMessageSender esMessageSender = new EsMessageSender(index, mqMessageProduct);
        EsProcessor esProcessor = EsPlugin.getEsProcessor(sinkJobConfig.getStorageInfo(), esMessageSender::compensateSend);
        esMessageSender.setEsProcessor(esProcessor);
        return esMessageSender;
    }

    private static MessageSender getDorisMessageSender(SinkJobConfig sinkJobConfig, MqMessageProduct mqMessageProduct) {
        return new DorisMessageSender(sinkJobConfig.getIndex(), mqMessageProduct, sinkJobConfig.getStorageInfo(), sinkJobConfig.getColumnList());
    }
}

