/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.common;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public abstract class DateUtils {
    public static final long SECONDS_OF_DAY = 86400L;
    public static final long MILLISECONDS_OF_DAY = 86400000L;
    public static final long SECONDS_OF_HOUR = 3600L;
    public static final long MILLISECONDS_OF_HOUR = 3600000L;
    public static final long SECONDS_OF_MONTH = 2592000L;

    public static String timeToStr() {
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddhhmm");
        return ldt.format(formatter);
    }

    public static String timeDayToStr() {
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return ldt.format(formatter);
    }

    public static String timeMinToStr(LocalDateTime ldt) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        return ldt.format(formatter);
    }

    public static long getStartOfToday() {
        long now = System.currentTimeMillis() / 1000L;
        long daySecond = 86400L;
        long dayStart = now - (now + 28800L) % daySecond;
        return dayStart;
    }

    public static long getEndOfToday() {
        long now = System.currentTimeMillis() / 1000L;
        long dayEnd = now - (now + 28800L) % 86400L + 86400L;
        return dayEnd;
    }

    public static int getDateOfDaysBefore(int days) {
        long now = System.currentTimeMillis();
        long nowOfDaysBefore = now - 86400000L * (long)days;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String time = fmt.format(new Date(nowOfDaysBefore));
        return Integer.valueOf(time);
    }

    public static int getDateOfTime(long rawTime) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String time = fmt.format(new Date(rawTime * 1000L));
        return Integer.valueOf(time);
    }

    public static String getNow() {
        DateTimeFormatter fmTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return now.format(fmTime);
    }
}

