/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import cn.hutool.core.date.DateUtil;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateFormat;

public interface LogParser {
    public static final String LOG_PREFIX = "[";
    public static final String LOG_SUFFFIX = "]";
    public static final Integer TIME_STAMP_MILLI_LENGTH = 13;
    public static final DateParser dateFormat1 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    public static final DateParser dateFormat2 = FastDateFormat.getInstance((String)"yy-MM-dd HH:mm:ss");
    public static final DateParser dateFormat3 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateParser dateFormat4 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss,SSS");
    public static final Integer specialTimeLength = dateFormat1.getPattern().length();
    public static final String specialTimePrefix = "20";
    public static final String esKeyMap_timestamp = "timestamp";
    public static final String esKeyMap_Date = "Date";
    public static final String esKeyMap_topic = "mqtopic";
    public static final String esKeyMap_tag = "mqtag";
    public static final String esKeyMap_logstoreName = "logstore";
    public static final String ES_KEY_MAP_LOG_SOURCE = "logsource";
    public static final String ES_KEY_MAP_MESSAGE = "message";
    public static final String esKeyMap_tail = "tail";
    public static final String ES_KEY_MAP_TAIL_ID = "tailId";
    public static final String esKeyMap_logip = "logip";
    public static final String esKeyMap_lineNumber = "linenumber";
    public static final String esKyeMap_fileName = "filename";
    public static final String TRACE_ID_KEY = "traceId";
    public static final String PACKAGE_NAME = "com.xiaomi.mone.log";

    public Map<String, Object> parse(String var1, String var2, Long var3, Long var4, String var5);

    public Map<String, Object> parseSimple(String var1, Long var2);

    public List<String> parseLogData(String var1) throws Exception;

    default public Long getTimestampFromString(String logTime, Long collectStamp) {
        Long timeStamp;
        try {
            timeStamp = DateUtil.parse((CharSequence)logTime).getTime();
        }
        catch (Exception e) {
            try {
                logTime = String.format("%s%s", String.valueOf(DateUtil.thisYear()).substring(0, 2), logTime);
                timeStamp = DateUtil.parse((CharSequence)logTime).getTime();
            }
            catch (Exception ex) {
                timeStamp = collectStamp;
            }
        }
        return null != timeStamp && timeStamp.toString().length() == TIME_STAMP_MILLI_LENGTH.intValue() ? timeStamp.longValue() : Instant.now().toEpochMilli();
    }
}

