/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Strings;

public abstract class MappingMethod
extends ModelElement {
    private final String name;
    private final List<Parameter> parameters;
    private final List<Parameter> sourceParameters;
    private final Type returnType;
    private final Parameter targetParameter;
    private final Accessibility accessibility;
    private final List<Type> thrownTypes;
    private final boolean isStatic;
    private final String resultName;
    private final List<LifecycleCallbackMethodReference> beforeMappingReferencesWithMappingTarget;
    private final List<LifecycleCallbackMethodReference> beforeMappingReferencesWithoutMappingTarget;
    private final List<LifecycleCallbackMethodReference> afterMappingReferences;

    protected MappingMethod(Method method, Collection<String> existingVariableNames, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        this(method, method.getParameters(), existingVariableNames, beforeMappingReferences, afterMappingReferences);
    }

    protected MappingMethod(Method method, List<Parameter> parameters, Collection<String> existingVariableNames, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        this.name = method.getName();
        this.parameters = parameters;
        this.sourceParameters = Parameter.getSourceParameters(parameters);
        this.returnType = method.getReturnType();
        this.targetParameter = method.getMappingTargetParameter();
        this.accessibility = method.getAccessibility();
        this.thrownTypes = method.getThrownTypes();
        this.isStatic = method.isStatic();
        this.resultName = this.initResultName(existingVariableNames);
        this.beforeMappingReferencesWithMappingTarget = this.filterMappingTarget(beforeMappingReferences, true);
        this.beforeMappingReferencesWithoutMappingTarget = this.filterMappingTarget(beforeMappingReferences, false);
        this.afterMappingReferences = afterMappingReferences;
    }

    protected MappingMethod(Method method, List<Parameter> parameters) {
        this(method, parameters, new ArrayList<String>(method.getParameterNames()), null, null);
    }

    protected MappingMethod(Method method) {
        this(method, new ArrayList<String>(method.getParameterNames()), null, null);
    }

    protected MappingMethod(Method method, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        this(method, new ArrayList<String>(method.getParameterNames()), beforeMappingReferences, afterMappingReferences);
    }

    private String initResultName(Collection<String> existingVarNames) {
        if (this.targetParameter != null) {
            return this.targetParameter.getName();
        }
        if (this.getResultType().isArrayType()) {
            String name = Strings.getSafeVariableName(this.getResultType().getComponentType().getName() + "Tmp", existingVarNames);
            existingVarNames.add(name);
            return name;
        }
        String name = Strings.getSafeVariableName(this.getResultType().getName(), existingVarNames);
        existingVarNames.add(name);
        return name;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Parameter> getSourceParameters() {
        return this.sourceParameters;
    }

    public Type getResultType() {
        return this.targetParameter != null ? this.targetParameter.getType() : this.returnType;
    }

    public String getResultName() {
        return this.resultName;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public boolean isExistingInstanceMapping() {
        return this.targetParameter != null;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> types = new HashSet<Type>();
        for (Parameter param : this.parameters) {
            types.addAll(param.getType().getImportTypes());
        }
        types.addAll(this.getReturnType().getImportTypes());
        for (Type type : this.thrownTypes) {
            types.addAll(type.getImportTypes());
        }
        return types;
    }

    protected List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameters.size());
        for (Parameter parameter : this.parameters) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    public List<Type> getThrownTypes() {
        return this.thrownTypes;
    }

    public String toString() {
        return this.returnType + " " + this.getName() + "(" + Strings.join(this.parameters, ", ") + ")";
    }

    private List<LifecycleCallbackMethodReference> filterMappingTarget(List<LifecycleCallbackMethodReference> methods, boolean mustHaveMappingTargetParameter) {
        if (methods == null) {
            return null;
        }
        ArrayList<LifecycleCallbackMethodReference> result = new ArrayList<LifecycleCallbackMethodReference>(methods.size());
        for (LifecycleCallbackMethodReference method : methods) {
            if (mustHaveMappingTargetParameter != method.hasMappingTargetParameter()) continue;
            result.add(method);
        }
        return result;
    }

    public List<LifecycleCallbackMethodReference> getAfterMappingReferences() {
        return this.afterMappingReferences;
    }

    public List<LifecycleCallbackMethodReference> getBeforeMappingReferencesWithMappingTarget() {
        return this.beforeMappingReferencesWithMappingTarget;
    }

    public List<LifecycleCallbackMethodReference> getBeforeMappingReferencesWithoutMappingTarget() {
        return this.beforeMappingReferencesWithoutMappingTarget;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
        hash = 83 * hash + (this.returnType != null ? this.returnType.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingMethod other = (MappingMethod)obj;
        if (!Objects.equals(this.parameters, other.parameters)) {
            return false;
        }
        return Objects.equals(this.returnType, other.returnType);
    }
}

