/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.xiaomi.data.push.nacos.NacosNaming;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.nacos.FetchStreamMachineService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosFetchStreamMachineService
implements FetchStreamMachineService {
    private static final Logger log = LoggerFactory.getLogger(NacosFetchStreamMachineService.class);
    private final NacosNaming nacosNaming;

    public NacosFetchStreamMachineService(NacosNaming nacosNaming) {
        this.nacosNaming = nacosNaming;
    }

    @Override
    public List<String> streamMachineUnique() {
        this.preCheckNaming(this.nacosNaming);
        ArrayList uniqueKeys = Lists.newArrayList();
        try {
            List allInstances = this.nacosNaming.getAllInstances(CommonExtensionServiceFactory.getCommonExtensionService().getHeraLogStreamServerName());
            return this.extractUniqueKeys(allInstances);
        }
        catch (NacosException e) {
            log.error("nacos queryStreamMachineIps error", (Throwable)e);
            return uniqueKeys;
        }
    }

    @Override
    public List<String> getStreamList(String dataId) {
        this.preCheckNaming(this.nacosNaming);
        ArrayList uniqueKeys = Lists.newArrayList();
        try {
            List allInstances = this.nacosNaming.getAllInstances(dataId);
            return this.extractUniqueKeys(allInstances);
        }
        catch (NacosException e) {
            log.error("nacos queryStreamMachineIps error,dataId:{}", (Object)dataId, (Object)e);
            return uniqueKeys;
        }
    }

    private void preCheckNaming(NacosNaming nacosNaming) {
        if (null == nacosNaming) {
            throw new MilogManageException("please set nacos naming first");
        }
    }

    private List<String> extractUniqueKeys(List<Instance> instances) {
        return instances.stream().map(this::extractKeyFromInstance).distinct().collect(Collectors.toList());
    }

    private String extractKeyFromInstance(Instance instance) {
        if (instance.getMetadata().containsKey("MONE_CONTAINER_S_POD_NAME")) {
            return StringUtils.substringAfterLast((String)((String)instance.getMetadata().get("MONE_CONTAINER_S_POD_NAME")), (String)"-");
        }
        return instance.getIp();
    }
}

