/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.model.vo.AgentLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.TailLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.api.service.LogProcessCollector;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogProcess {
    private static final Logger log = LoggerFactory.getLogger(LogProcess.class);
    @Resource
    private MilogLogTailDao logtailDao;
    private Map<String, List<UpdateLogProcessCmd.CollectDetail>> tailProgressMap = new ConcurrentHashMap<String, List<UpdateLogProcessCmd.CollectDetail>>(256);
    @Reference(interfaceClass=LogProcessCollector.class, group="$dubbo.env.group", check=false, timeout=14000)
    private LogProcessCollector logProcessCollector;

    public void updateLogProcess(UpdateLogProcessCmd cmd) {
        log.debug("[LogProcess.updateLogProcess] cmd:{} ", (Object)cmd);
        if (cmd == null || StringUtils.isEmpty((String)cmd.getIp())) {
            return;
        }
        this.tailProgressMap.put(cmd.getIp(), cmd.getCollectList());
    }

    public List<AgentLogProcessDTO> getAgentLogProcess(String ip) {
        return this.logProcessCollector.getAgentLogProcess(ip);
    }

    public List<TailLogProcessDTO> getTailLogProcess(Long tailId, String targetIp) {
        if (tailId == null) {
            return Lists.newArrayList();
        }
        MilogLogTailDo logTail = this.logtailDao.queryById(tailId);
        if (null == logTail) {
            return Lists.newArrayList();
        }
        return this.logProcessCollector.getTailLogProcess(tailId, logTail.getTail(), targetIp);
    }

    public List<TailLogProcessDTO> getStoreLogProcess(Long storeId, String targetIp) {
        if (storeId == null) {
            return new ArrayList<TailLogProcessDTO>();
        }
        List<MilogLogTailDo> logtailList = this.logtailDao.getMilogLogtailByStoreId(storeId);
        ArrayList<TailLogProcessDTO> dtoList = new ArrayList<TailLogProcessDTO>();
        for (MilogLogTailDo milogLogtailDo : logtailList) {
            List<TailLogProcessDTO> processList = this.getTailLogProcess(milogLogtailDo.getId(), targetIp);
            if (processList.isEmpty()) continue;
            dtoList.addAll(processList);
        }
        return dtoList;
    }

    public List<UpdateLogProcessCmd.CollectDetail> getColProcessImperfect(Double progressRation) {
        return this.logProcessCollector.getColProcessImperfect(progressRation);
    }

    public Map<String, List<UpdateLogProcessCmd.CollectDetail>> getTailProgressMap() {
        return this.tailProgressMap;
    }
}

