/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionServiceFactory;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.pager.Pager;

@Service
public class MilogMiddlewareConfigDao {
    @Resource
    private NutDao dao;

    public List<MilogMiddlewareConfig> queryMiddlewareConfigByCondition(Condition cnd, Pager pager) {
        if (null == pager) {
            return this.dao.query(MilogMiddlewareConfig.class, cnd);
        }
        return this.dao.query(MilogMiddlewareConfig.class, cnd, pager);
    }

    public Integer queryMiddlewareConfigCountByCondition(Condition cnd) {
        return this.dao.count(MilogMiddlewareConfig.class, cnd);
    }

    public void addMiddlewareConfig(MilogMiddlewareConfig addParamToAddEntity) {
        this.dao.insert((Object)addParamToAddEntity);
    }

    public MilogMiddlewareConfig queryById(Long id) {
        return (MilogMiddlewareConfig)this.dao.fetch(MilogMiddlewareConfig.class, id.longValue());
    }

    public void updateMiddlewareConfig(MilogMiddlewareConfig middlewareConfig) {
        this.dao.update((Object)middlewareConfig);
    }

    public void deleteMiddlewareConfig(Long id) {
        this.dao.delete(MilogMiddlewareConfig.class, id.longValue());
    }

    public List<MilogMiddlewareConfig> queryCurrentMontorRoomMQ(String montorRoomEn) {
        List middlewareConfigs = this.dao.query(MilogMiddlewareConfig.class, (Condition)Cnd.where((String)"region_en", (String)"=", (Object)montorRoomEn.trim()));
        if (CollectionUtils.isNotEmpty((Collection)middlewareConfigs)) {
            return middlewareConfigs.stream().filter(middlewareConfig -> CommonExtensionServiceFactory.getCommonExtensionService().middlewareEnumValid(middlewareConfig.getType())).collect(Collectors.toList());
        }
        return null;
    }

    public MilogMiddlewareConfig queryDefaultMiddlewareConfig() {
        List defaultConfigList = this.dao.query(MilogMiddlewareConfig.class, (Condition)Cnd.where((String)"region_en", (String)"=", (Object)MachineRegionEnum.CN_MACHINE.getEn()).and("is_default", "=", (Object)1));
        if (CollectionUtils.isNotEmpty((Collection)defaultConfigList)) {
            return defaultConfigList.stream().filter(middlewareConfig -> CommonExtensionServiceFactory.getCommonExtensionService().middlewareEnumValid(middlewareConfig.getType())).findFirst().orElse(null);
        }
        return null;
    }

    public MilogMiddlewareConfig queryCurrentEnvNacos(String enName) {
        Cnd cnd = Cnd.where((String)"type", (String)"=", (Object)MiddlewareEnum.NCOS.getCode()).and("region_en", "=", (Object)enName);
        List milogMiddlewareConfigs = this.dao.query(MilogMiddlewareConfig.class, (Condition)cnd);
        if (CollectionUtils.isNotEmpty((Collection)milogMiddlewareConfigs)) {
            return (MilogMiddlewareConfig)milogMiddlewareConfigs.get(milogMiddlewareConfigs.size() - 1);
        }
        return null;
    }

    public List<MilogMiddlewareConfig> queryAll() {
        return this.dao.query(MilogMiddlewareConfig.class, null);
    }

    public MilogMiddlewareConfig queryDefaultMqMiddlewareConfigMotorRoom(String motorRooman) {
        Cnd cnd = Cnd.where((String)"type", (String)"in", (Object)ResourceExtensionServiceFactory.getResourceExtensionService().getResourceCode()).and("region_en", "=", (Object)motorRooman);
        List milogMiddlewareConfigs = this.dao.query(MilogMiddlewareConfig.class, (Condition)cnd);
        if (CollectionUtils.isNotEmpty((Collection)milogMiddlewareConfigs) && milogMiddlewareConfigs.size() == 1) {
            return (MilogMiddlewareConfig)milogMiddlewareConfigs.get(milogMiddlewareConfigs.size() - 1);
        }
        if (CollectionUtils.isNotEmpty((Collection)milogMiddlewareConfigs) && milogMiddlewareConfigs.size() > 1) {
            return milogMiddlewareConfigs.stream().filter(milogMiddlewareConfig -> Constant.YES.intValue() == milogMiddlewareConfig.getIsDefault().intValue()).findFirst().get();
        }
        return null;
    }

    public MilogMiddlewareConfig queryNacosRegionByNameServer(String nameServer) {
        Cnd cnd = Cnd.where((String)"type", (String)"=", (Object)MiddlewareEnum.NCOS.getCode()).and("name_server", "=", (Object)nameServer);
        List milogMiddlewareConfigs = this.dao.query(MilogMiddlewareConfig.class, (Condition)cnd);
        if (CollectionUtils.isNotEmpty((Collection)milogMiddlewareConfigs)) {
            return (MilogMiddlewareConfig)milogMiddlewareConfigs.get(milogMiddlewareConfigs.size() - 1);
        }
        return null;
    }

    public List<MilogMiddlewareConfig> queryByResourceCode(Integer resourceCode, String regionCode) {
        Cnd cnd = Cnd.where((String)"type", (String)"=", (Object)resourceCode);
        cnd.and("region_en", "=", (Object)regionCode);
        cnd.orderBy("utime", "desc");
        return this.dao.query(MilogMiddlewareConfig.class, (Condition)cnd);
    }

    public List<MilogMiddlewareConfig> queryByResourceCodes(List<Integer> resourceCodes, String regionCode) {
        Cnd cnd = Cnd.where((String)"type", (String)"in", resourceCodes);
        cnd.and("region_en", "=", (Object)regionCode);
        return this.dao.query(MilogMiddlewareConfig.class, (Condition)cnd);
    }

    public List<MilogMiddlewareConfig> selectByAlias(String alias) {
        Cnd cnd = Cnd.where((String)"alias", (String)"=", (Object)alias);
        return this.dao.query(MilogMiddlewareConfig.class, (Condition)cnd);
    }
}

