/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.validation;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Component;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.model.bo.StoreSpaceAuth;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class StoreSpaceAuthValid {
    private static final Logger log = LoggerFactory.getLogger(StoreSpaceAuthValid.class);
    @Resource
    private MilogLogstoreDao milogLogstoreDao;
    @Resource
    private MilogSpaceDao milogSpaceDao;

    public String validParam(StoreSpaceAuth storeSpaceAuth) {
        ArrayList errorInfos = Lists.newArrayList();
        if (null == storeSpaceAuth) {
            errorInfos.add("The parameter cannot be empty");
        }
        if (null == storeSpaceAuth.getStoreId()) {
            errorInfos.add("The store ID cannot be empty");
        }
        if (null == storeSpaceAuth.getSpaceId()) {
            errorInfos.add("The space ID cannot be empty");
        }
        return errorInfos.stream().collect(Collectors.joining(","));
    }

    public String validStoreAuthData(StoreSpaceAuth storeSpaceAuth) {
        MilogSpaceDO milogSpaceDO;
        ArrayList errorInfos = Lists.newArrayList();
        MilogLogStoreDO milogLogStoreDO = this.milogLogstoreDao.queryById(storeSpaceAuth.getStoreId());
        if (null == milogLogStoreDO) {
            errorInfos.add("The store information does not exist, please check if it is correct");
        }
        if (null == (milogSpaceDO = this.milogSpaceDao.queryById(storeSpaceAuth.getSpaceId()))) {
            errorInfos.add("The space information does not exist, please check if it is correct");
        }
        if (storeSpaceAuth.getSpaceId().equals(milogLogStoreDO.getSpaceId())) {
            errorInfos.add("The store already belongs to the space and cannot be relicensed");
        }
        return errorInfos.stream().collect(Collectors.joining(","));
    }
}

