/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.validation;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.enums.ResourceEnum;
import org.apache.ozhera.log.api.model.bo.MiLogResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ResourceValidation {
    private static final Logger log = LoggerFactory.getLogger(ResourceValidation.class);

    public String resourceOperateValid(MiLogResource miLogResource) {
        boolean esIndexExist;
        boolean operateBoolean;
        ArrayList errorInfos = Lists.newArrayList();
        if (null == miLogResource.getOperateCode()) {
            errorInfos.add("operateCode cannot be empty");
        }
        boolean bl = operateBoolean = Objects.equals(OperateEnum.UPDATE_OPERATE.getCode(), miLogResource.getOperateCode()) || Objects.equals(OperateEnum.DELETE_OPERATE.getCode(), miLogResource.getOperateCode());
        if (operateBoolean && null == miLogResource.getId()) {
            errorInfos.add("id cannot be empty");
        }
        if (null == miLogResource.getResourceCode()) {
            errorInfos.add("resourceCode cannot be empty");
        }
        if (null != miLogResource.getResourceCode() && null != miLogResource.getOperateCode() && OperateEnum.DELETE_OPERATE.getCode().equals(miLogResource.getOperateCode())) {
            return errorInfos.stream().collect(Collectors.joining(","));
        }
        if (MiddlewareEnum.ELASTICSEARCH.getCode().equals(miLogResource.getResourceCode())) {
            if (StringUtils.isBlank((CharSequence)miLogResource.getConWay())) {
                errorInfos.add("conWay  cannot be empty");
            }
            if (StringUtils.isBlank((CharSequence)miLogResource.getClusterName())) {
                errorInfos.add("clusterName  cannot be empty");
            }
            if (!Objects.equals("pwd", miLogResource.getConWay()) || StringUtils.isBlank((CharSequence)miLogResource.getAk()) || StringUtils.isBlank((CharSequence)miLogResource.getSk())) {
                // empty if block
            }
            if (Objects.equals("token", miLogResource.getConWay()) && (StringUtils.isBlank((CharSequence)miLogResource.getEsToken()) || StringUtils.isBlank((CharSequence)miLogResource.getCatalog()) || StringUtils.isBlank((CharSequence)miLogResource.getDatabase()))) {
                errorInfos.add("If the connection mode is token, the token, catalog cluster, and database name cannot be empty");
            }
        }
        if (StringUtils.isBlank((CharSequence)miLogResource.getAlias())) {
            errorInfos.add("alias cannot be empty");
        }
        if (StringUtils.isBlank((CharSequence)miLogResource.getRegionEn())) {
            errorInfos.add("Region code cannot be empty");
        }
        boolean bl2 = esIndexExist = MiddlewareEnum.ELASTICSEARCH.getCode().equals(miLogResource.getResourceCode()) && CollectionUtils.isEmpty((Collection)miLogResource.getMultipleEsIndex());
        if (esIndexExist && StringUtils.equalsIgnoreCase((CharSequence)LogStorageTypeEnum.ELASTICSEARCH.name(), (CharSequence)miLogResource.getStorageType())) {
            errorInfos.add("ES index information cannot be empty");
        }
        if (ResourceEnum.MQ.getCode().equals(miLogResource.getResourceCode()) && StringUtils.isEmpty((CharSequence)miLogResource.getClusterName())) {
            errorInfos.add("MQ address information cannot be empty");
        }
        return errorInfos.stream().collect(Collectors.joining(","));
    }
}

