/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.RyuFloat;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class CSVWriter
implements Closeable,
Flushable {
    private long features;
    static final byte[] BYTES_TRUE = "true".getBytes();
    static final byte[] BYTES_FALSE = "false".getBytes();
    final OutputStream out;
    final Charset charset;
    byte[] bytes;
    int off;

    public CSVWriter(OutputStream out, Charset charset, Feature ... features) {
        for (Feature feature : features) {
            this.features |= feature.mask;
        }
        this.out = out;
        this.charset = charset;
        this.bytes = new byte[65536];
    }

    public static CSVWriter of() {
        return CSVWriter.of((OutputStream)new ByteArrayOutputStream(), new Feature[0]);
    }

    public static CSVWriter of(File file) throws FileNotFoundException {
        return CSVWriter.of((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
    }

    public static CSVWriter of(File file, Charset charset) throws FileNotFoundException {
        return CSVWriter.of((OutputStream)new FileOutputStream(file), charset);
    }

    public void writeRowObject(Object object) {
        Class<?> objectClass;
        if (object == null) {
            this.writeRow(new Object[0]);
            return;
        }
        ObjectWriterProvider provider = JSONFactory.getDefaultObjectWriterProvider();
        ObjectWriter objectWriter = provider.getObjectWriter(objectClass = object.getClass());
        if (objectWriter instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter adapter = (ObjectWriterAdapter)objectWriter;
            List<FieldWriter> fieldWriters = adapter.getFieldWriters();
            if (fieldWriters.size() == 1 && (fieldWriters.get((int)0).features & 0x1000000000000L) != 0L) {
                Object fieldValue = fieldWriters.get(0).getFieldValue(object);
                this.writeRowObject(fieldValue);
                return;
            }
            Object[] values = new Object[fieldWriters.size()];
            for (int i = 0; i < fieldWriters.size(); ++i) {
                values[i] = fieldWriters.get(i).getFieldValue(object);
            }
            this.writeRow(values);
        } else {
            this.writeRow(object);
        }
    }

    protected void writeDate(Date date) {
        if (date == null) {
            return;
        }
        long millis = date.getTime();
        this.writeInstant(Instant.ofEpochMilli(millis));
    }

    protected void writeInstant(Instant instant) {
        if (instant == null) {
            return;
        }
        ZonedDateTime zdt = instant.atZone(ZoneOffset.UTC);
        String str = DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zdt);
        if ((this.features & Feature.AlwaysQuoteStrings.mask) != 0L) {
            this.writeRaw('\"');
            this.writeRaw(str);
            this.writeRaw('\"');
        } else {
            this.writeRaw(str);
        }
    }

    protected void writeDate(LocalDate date) {
        if (date == null) {
            return;
        }
        String str = DateTimeFormatter.ISO_LOCAL_DATE.format(date);
        this.writeRaw(str);
    }

    protected void writeDateTime(LocalDateTime instant) {
        if (instant == null) {
            return;
        }
        String str = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(instant);
        this.writeRaw(str);
    }

    protected void writeDirect(byte[] bytes, int off, int len) {
        try {
            this.out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    public void writeRow(Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            byte[] bytes;
            String str;
            Object value;
            if (i != 0) {
                if (this.off + 1 >= this.bytes.length) {
                    this.flush();
                }
                this.bytes[this.off++] = 44;
            }
            if ((value = values[i]) == null) continue;
            if (value instanceof Optional) {
                Optional optional = (Optional)value;
                if (!optional.isPresent()) continue;
                value = optional.get();
            }
            if (value instanceof Integer) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.writeInt64((Long)value);
                continue;
            }
            if (value instanceof String) {
                this.writeString((String)value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean booleanValue = (Boolean)value;
                byte[] valueBytes = booleanValue ? BYTES_TRUE : BYTES_FALSE;
                this.writeRaw(valueBytes);
                continue;
            }
            if (value instanceof Float) {
                float floatValue = ((Float)value).floatValue();
                if (Float.isNaN(floatValue) || Float.isInfinite(floatValue)) continue;
                if (this.off + 15 > this.bytes.length) {
                    this.flush();
                }
                int size = RyuFloat.toString(floatValue, this.bytes, this.off);
                this.off += size;
                continue;
            }
            if (value instanceof Double) {
                this.writeDouble((Double)value);
                continue;
            }
            if (value instanceof Short) {
                this.writeInt32(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Byte) {
                this.writeInt32(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                str = value.toString();
                bytes = str.getBytes(StandardCharsets.ISO_8859_1);
                this.writeRaw(bytes);
                continue;
            }
            if (value instanceof BigInteger) {
                str = value.toString();
                bytes = str.getBytes(StandardCharsets.ISO_8859_1);
                this.writeRaw(bytes);
                continue;
            }
            if (value instanceof Date) {
                this.writeDate((Date)value);
                continue;
            }
            if (value instanceof Instant) {
                this.writeInstant((Instant)value);
                continue;
            }
            if (value instanceof LocalDate) {
                this.writeDate((LocalDate)value);
                continue;
            }
            if (value instanceof LocalDateTime) {
                this.writeDateTime((LocalDateTime)value);
                continue;
            }
            str = value.toString();
            bytes = str.getBytes(this.charset);
            this.writeString(bytes);
        }
        if (this.off + 1 >= this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = 10;
    }

    protected void writeInt64(Long value) {
        long longValue = value;
        if (longValue == Long.MIN_VALUE) {
            this.writeRaw("-9223372036854775808");
            return;
        }
        int size = longValue < 0L ? IOUtils.stringSize(-longValue) + 1 : IOUtils.stringSize(longValue);
        int minCapacity = this.off + size;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        IOUtils.getChars(longValue, this.off + size, this.bytes);
        this.off += size;
    }

    protected void writeDouble(Double value) {
        double doubleValue = value;
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return;
        }
        if (this.off + 24 > this.bytes.length) {
            this.flush();
        }
        int size = RyuDouble.toString(doubleValue, this.bytes, this.off);
        this.off += size;
    }

    protected void writeString(String value) {
        String str = value;
        byte[] bytes = JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == JDKUtils.LATIN1.byteValue() ? JDKUtils.STRING_VALUE.apply(str) : str.getBytes(this.charset);
        this.writeString(bytes);
    }

    protected void writeInt32(int intValue) {
        if (intValue == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int size = intValue < 0 ? IOUtils.stringSize(-intValue) + 1 : IOUtils.stringSize(intValue);
        int minCapacity = this.off + size;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        IOUtils.getChars(intValue, this.off + size, this.bytes);
        this.off += size;
    }

    @Override
    public void flush() {
        try {
            this.out.write(this.bytes, 0, this.off);
            this.off = 0;
            this.out.flush();
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    private void writeString(byte[] utf8Bytes) {
        int j;
        byte ch;
        int i;
        if (utf8Bytes == null || utf8Bytes.length == 0) {
            return;
        }
        int len = utf8Bytes.length;
        int escapeCount = 0;
        boolean comma = false;
        if (utf8Bytes[0] == 34) {
            for (i = 0; i < len; ++i) {
                ch = utf8Bytes[i];
                if (ch != 34) continue;
                ++escapeCount;
            }
        } else {
            for (i = 0; i < len; ++i) {
                ch = utf8Bytes[i];
                if (ch == 44) {
                    comma = true;
                    continue;
                }
                if (ch != 34) continue;
                ++escapeCount;
            }
            if (!comma) {
                escapeCount = 0;
            }
        }
        if (escapeCount == 0) {
            this.writeRaw(utf8Bytes);
            return;
        }
        if (utf8Bytes[0] == 34) {
            byte[] bytes = new byte[utf8Bytes.length + 2 + escapeCount];
            j = 0;
            bytes[0] = 34;
            int end = this.off + len;
            for (int i2 = this.off; i2 < end; ++i2) {
                byte b = bytes[i2];
                bytes[j++] = b;
                if (b != 34) continue;
                bytes[j++] = b;
            }
            bytes[j] = 34;
            this.writeRaw(bytes);
        } else {
            byte[] bytes = new byte[utf8Bytes.length + 2 + escapeCount];
            j = 0;
            bytes[0] = 34;
            int end = this.off + len;
            for (int i3 = this.off; i3 < end; ++i3) {
                byte b = bytes[i3];
                bytes[j++] = b;
                if (b != 34) continue;
                bytes[j++] = b;
            }
            bytes[j] = 34;
            this.writeRaw(bytes);
        }
    }

    protected void writeDecimal(BigDecimal value) {
        if (value == null) {
            return;
        }
        this.writeRaw(value.toString());
    }

    public String toString() {
        if (this.out instanceof ByteArrayOutputStream) {
            this.flush();
            byte[] strBytes = ((ByteArrayOutputStream)this.out).toByteArray();
            return new String(strBytes, StandardCharsets.UTF_8);
        }
        return super.toString();
    }

    protected void writeRaw(byte[] strBytes) {
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    protected void writeRaw(char ch) {
        if (ch < '\u0000' || ch > '\u007f') {
            throw new JSONException("unsupported operation");
        }
        if (this.off + 1 == this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = (byte)ch;
    }

    protected void writeRaw(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        byte[] strBytes = str.getBytes(this.charset);
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.off > 0) {
            this.flush();
        }
        this.out.close();
    }

    public static CSVWriter of(OutputStream out, Feature ... features) {
        return new CSVWriter(out, StandardCharsets.UTF_8, features);
    }

    public static CSVWriter of(OutputStream out, Charset charset) {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            throw new UnsupportedOperationException("not support charset : " + charset);
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return new CSVWriter(out, charset, new Feature[0]);
    }

    public static enum Feature {
        AlwaysQuoteStrings(1L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }
}

