/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

class CSVReaderUTF16
extends CSVReader {
    char[] buf;
    Reader input;

    CSVReaderUTF16(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    CSVReaderUTF16(Reader input, ObjectReaderAdapter objectReader) {
        super(objectReader);
        this.input = input;
    }

    CSVReaderUTF16(Reader input, Type[] types) {
        super(types);
        this.input = input;
    }

    CSVReaderUTF16(char[] bytes, int off, int len, ObjectReaderAdapter objectReader) {
        super(objectReader);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVReaderUTF16(char[] bytes, int off, int len, Type[] types) {
        super(types);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    @Override
    protected boolean seekLine() throws IOException {
        if (this.buf == null && this.input != null) {
            this.buf = new char[524288];
            int cnt = this.input.read(this.buf);
            if (cnt == -1) {
                this.inputEnd = true;
                return false;
            }
            this.end = cnt;
            if (this.end > 3 && this.buf[0] == '\uffffffef' && this.buf[1] == '\uffffffbb' && this.buf[2] == '\uffffffbf') {
                this.lineNextStart = this.off = 3;
            }
        }
        for (int k = 0; k < 3; ++k) {
            this.lineTerminated = false;
            for (int i = this.off; i < this.end; ++i) {
                int n;
                char ch;
                if (i + 4 < this.end) {
                    char b0 = this.buf[i];
                    char b1 = this.buf[i + 1];
                    char b2 = this.buf[i + 2];
                    char b3 = this.buf[i + 3];
                    if (b0 > '\"' && b1 > '\"' && b2 > '\"' && b3 > '\"') {
                        this.lineSize += 4;
                        i += 3;
                        continue;
                    }
                }
                if ((ch = this.buf[i]) == '\"') {
                    ++this.lineSize;
                    if (!this.quote) {
                        this.quote = true;
                        continue;
                    }
                    n = i + 1;
                    if (n >= this.end) break;
                    if (this.buf[n] == '\"') {
                        ++this.lineSize;
                        ++i;
                        continue;
                    }
                    this.quote = false;
                    continue;
                }
                if (this.quote) {
                    ++this.lineSize;
                    continue;
                }
                if (ch == '\n') {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = this.off = i + 1;
                    break;
                }
                if (ch == '\r') {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    n = i + 1;
                    if (n >= this.end) break;
                    if (this.buf[n] == '\n') {
                        ++i;
                    }
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = this.off = i + 1;
                    break;
                }
                ++this.lineSize;
            }
            if (!this.lineTerminated) {
                if (this.input != null && !this.inputEnd) {
                    int cnt;
                    int len = this.end - this.off;
                    if (this.off > 0) {
                        if (len > 0) {
                            System.arraycopy(this.buf, this.off, this.buf, 0, len);
                        }
                        this.lineNextStart = 0;
                        this.lineStart = 0;
                        this.off = 0;
                        this.end = len;
                        this.quote = false;
                    }
                    if ((cnt = this.input.read(this.buf, this.end, this.buf.length - this.end)) == -1) {
                        this.inputEnd = true;
                        if (this.off == this.end) {
                            return false;
                        }
                    } else {
                        this.end += cnt;
                        continue;
                    }
                }
                this.lineStart = this.lineNextStart;
                this.lineEnd = this.end;
                ++this.rowCount;
                this.lineSize = 0;
                this.off = this.end;
            }
            this.lineTerminated = this.off == this.end;
            break;
        }
        return true;
    }

    Object readValue(char[] chars, int off, int len, Type type) {
        if (type == Integer.class) {
            return TypeUtils.parseInt(chars, off, len);
        }
        if (type == Long.class) {
            return TypeUtils.parseLong(chars, off, len);
        }
        if (type == BigDecimal.class) {
            return TypeUtils.parseBigDecimal(chars, off, len);
        }
        if (type == Float.class) {
            if (len == 0) {
                return null;
            }
            return Float.valueOf(TypeUtils.parseFloat(chars, off, len));
        }
        if (type == Double.class) {
            if (len == 0) {
                return null;
            }
            return TypeUtils.parseDouble(chars, off, len);
        }
        String str = new String(chars, off, len);
        if (type == Date.class) {
            return DateUtils.parseDate(str, DateUtils.DEFAULT_ZONE_ID);
        }
        return TypeUtils.cast((Object)str, type);
    }

    @Override
    public boolean isEnd() {
        return this.inputEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] readLineValues(boolean strings) {
        ArrayList<String> valueList;
        Object[] values;
        block56: {
            Object value;
            int columnIndex;
            block52: {
                Type type;
                int valueSize;
                int valueStart;
                block57: {
                    try {
                        if (this.inputEnd) {
                            return null;
                        }
                        if (this.input == null && this.off >= this.end) {
                            return null;
                        }
                        boolean result = this.seekLine();
                        if (!result) {
                            return null;
                        }
                    }
                    catch (IOException e) {
                        throw new JSONException("seekLine error", e);
                    }
                    values = null;
                    valueList = null;
                    if (this.columns != null) {
                        values = strings ? new String[this.columns.size()] : new Object[this.columns.size()];
                    }
                    boolean quote = false;
                    valueStart = this.lineStart;
                    valueSize = 0;
                    int escapeCount = 0;
                    columnIndex = 0;
                    for (int i = this.lineStart; i < this.lineEnd; ++i) {
                        block54: {
                            Object value2;
                            block51: {
                                Type type2;
                                block55: {
                                    char ch;
                                    block50: {
                                        block53: {
                                            ch = this.buf[i];
                                            if (!quote) break block53;
                                            if (ch == '\"') {
                                                int n = i + 1;
                                                if (n < this.lineEnd) {
                                                    char c1 = this.buf[n];
                                                    if (c1 == '\"') {
                                                        valueSize += 2;
                                                        ++escapeCount;
                                                        ++i;
                                                        continue;
                                                    }
                                                    if (c1 == ',') {
                                                        ++i;
                                                        ch = c1;
                                                    }
                                                    break block50;
                                                } else if (n == this.lineEnd) {
                                                    break;
                                                }
                                                break block50;
                                            } else {
                                                ++valueSize;
                                                continue;
                                            }
                                        }
                                        if (ch == '\"') {
                                            quote = true;
                                            continue;
                                        }
                                    }
                                    if (ch != ',') break block54;
                                    Type type3 = type2 = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                                    if (!quote) break block55;
                                    if (escapeCount == 0) {
                                        if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                            value2 = new String(this.buf, valueStart + 1, valueSize);
                                            break block51;
                                        } else {
                                            try {
                                                value2 = this.readValue(this.buf, valueStart + 1, valueSize, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                        break block51;
                                    } else {
                                        char[] bytes = new char[valueSize - escapeCount];
                                        int valueEnd = valueStart + valueSize;
                                        int k = 0;
                                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                                            char c = this.buf[j];
                                            bytes[k++] = c;
                                            if (c != '\"' || this.buf[j + 1] != '\"') continue;
                                            ++j;
                                        }
                                        if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                            value2 = new String(bytes);
                                            break block51;
                                        } else {
                                            try {
                                                value2 = this.readValue(bytes, 0, bytes.length, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                    }
                                    break block51;
                                }
                                if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                    value2 = new String(this.buf, valueStart, valueSize);
                                } else {
                                    try {
                                        value2 = this.readValue(this.buf, valueStart, valueSize, type2);
                                    }
                                    catch (Exception e) {
                                        value2 = this.error(columnIndex, e);
                                    }
                                }
                            }
                            if (values != null) {
                                if (columnIndex < values.length) {
                                    values[columnIndex] = value2;
                                }
                            } else {
                                if (valueList == null) {
                                    valueList = new ArrayList();
                                }
                                valueList.add((String)value2);
                            }
                            quote = false;
                            valueStart = i + 1;
                            valueSize = 0;
                            escapeCount = 0;
                            ++columnIndex;
                            continue;
                        }
                        ++valueSize;
                    }
                    if (valueSize <= 0) break block56;
                    Type type4 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                    if (!quote) break block57;
                    if (escapeCount == 0) {
                        value = type == null || type == String.class || type == Object.class || strings ? new String(this.buf, valueStart + 1, valueSize) : this.readValue(this.buf, valueStart + 1, valueSize, type);
                        break block52;
                    } else {
                        char[] bytes = new char[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            char c = this.buf[j];
                            bytes[k++] = c;
                            if (c != '\"' || this.buf[j + 1] != '\"') continue;
                            ++j;
                        }
                        if (type == null || type == String.class || type == Object.class || strings) {
                            value = new String(bytes);
                            break block52;
                        } else {
                            try {
                                value = this.readValue(bytes, 0, bytes.length, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                    }
                    break block52;
                }
                if (type == null || type == String.class || type == Object.class || strings) {
                    value = new String(this.buf, valueStart, valueSize);
                } else {
                    try {
                        value = this.readValue(this.buf, valueStart, valueSize, type);
                    }
                    catch (Exception e) {
                        value = this.error(columnIndex, e);
                    }
                }
            }
            if (values != null) {
                if (columnIndex < values.length) {
                    values[columnIndex] = value;
                }
            } else {
                if (valueList == null) {
                    valueList = new ArrayList<String>();
                }
                valueList.add((String)value);
            }
        }
        if (values == null && valueList != null) {
            values = strings ? new String[valueList.size()] : new Object[valueList.size()];
            valueList.toArray(values);
        }
        return values;
    }

    @Override
    public void close() {
        if (this.input != null) {
            IOUtils.close(this.input);
        }
    }
}

