/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.stream;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class StreamReader {
    protected static final int SIZE_512K = 524288;
    protected ObjectReaderProvider provider;
    protected long features;
    protected Type[] types;
    protected ObjectReader[] typeReaders;
    protected ObjectReaderAdapter objectReader;
    protected int lineSize;
    protected int rowCount;
    protected int errorCount;
    protected int lineStart;
    protected int lineEnd;
    protected int lineNextStart;
    protected int end;
    protected int off;
    protected boolean inputEnd;
    protected boolean lineTerminated = true;
    protected Map<String, ColumnStat> columnStatsMap;
    protected List<String> columns;
    protected List<ColumnStat> columnStats;

    public StreamReader() {
    }

    public StreamReader(Type[] types) {
        this.types = types;
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader[] readers = new ObjectReader[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            readers[i] = type == String.class || type == Object.class ? null : provider.getObjectReader(type);
        }
        this.typeReaders = readers;
    }

    public StreamReader(ObjectReaderAdapter objectReader) {
        this.objectReader = objectReader;
    }

    protected abstract boolean seekLine() throws IOException;

    public abstract <T> T readLineObject();

    public static class ColumnStat {
        @JSONField(ordinal=-1)
        public final String name;
        public int values;
        public int nulls;
        public int integers;
        public int doubles;
        public int numbers;
        public int dates;
        public int booleans;
        public int precision;
        public int scale;
        public int nonAsciiStrings;
        public int errors;
        public int maps;
        public int arrays;

        public ColumnStat(String name) {
            this.name = name;
        }

        public void stat(byte[] bytes, int off, int len, Charset charset) {
            ++this.values;
            if (len == 0) {
                ++this.nulls;
                return;
            }
            int end = off + len;
            boolean nonAscii = false;
            for (int i = off; i < end; ++i) {
                byte b = bytes[i];
                if (b >= 0) continue;
                nonAscii = true;
                break;
            }
            if (nonAscii) {
                if (this.precision < len) {
                    this.precision = len;
                }
                ++this.nonAsciiStrings;
                return;
            }
            int precision = len;
            if (TypeUtils.isNumber(bytes, off, len)) {
                char ch = (char)bytes[off];
                if (ch == '+' || ch == '-') {
                    --precision;
                }
                ++this.numbers;
                if (TypeUtils.isInteger(bytes, off, len)) {
                    ++this.integers;
                } else {
                    boolean e = false;
                    int dotIndex = -1;
                    for (int i = off; i < end; ++i) {
                        byte b = bytes[i];
                        if (b == 46) {
                            dotIndex = i;
                            continue;
                        }
                        if (b != 101 && b != 69) continue;
                        e = true;
                    }
                    if (e) {
                        ++this.doubles;
                    } else if (dotIndex != -1) {
                        int scale = end - dotIndex - 1;
                        if (this.scale < scale) {
                            this.scale = scale;
                        }
                        --precision;
                    }
                }
            } else {
                boolean checkDate = false;
                int sub = 0;
                int slash = 0;
                int colon = 0;
                int dot = 0;
                int nums = 0;
                block15: for (int i = off; i < end; ++i) {
                    char ch = (char)bytes[i];
                    switch (ch) {
                        case '-': {
                            ++sub;
                            continue block15;
                        }
                        case '/': {
                            ++slash;
                            continue block15;
                        }
                        case ':': {
                            ++colon;
                            continue block15;
                        }
                        case '.': {
                            ++dot;
                            continue block15;
                        }
                        default: {
                            if (ch < '0' || ch > '9') continue block15;
                            ++nums;
                        }
                    }
                }
                if (!(checkDate || sub != 2 && slash != 2 && colon != 2)) {
                    checkDate = true;
                }
                if (checkDate && (nums < 4 || len > 36)) {
                    checkDate = false;
                }
                if (checkDate) {
                    try {
                        int nanoOfSeconds;
                        String str;
                        ZonedDateTime zdt;
                        LocalDateTime ldt = null;
                        switch (len) {
                            case 8: {
                                LocalDate localDate = DateUtils.parseLocalDate8(bytes, off);
                                ldt = localDate.atStartOfDay();
                                break;
                            }
                            case 9: {
                                LocalDate localDate = DateUtils.parseLocalDate9(bytes, off);
                                ldt = localDate.atStartOfDay();
                                break;
                            }
                            case 10: {
                                LocalDate localDate = DateUtils.parseLocalDate10(bytes, off);
                                ldt = localDate.atStartOfDay();
                                break;
                            }
                        }
                        if (ldt == null && (zdt = DateUtils.parseZonedDateTime(str = new String(bytes, off, len, charset))) != null) {
                            ldt = zdt.toLocalDateTime();
                        }
                        if (ldt != null) {
                            precision = 0;
                            ++this.dates;
                        }
                        if ((nanoOfSeconds = ldt.getNano()) != 0) {
                            precision = nanoOfSeconds % 100000000 == 0 ? 1 : (nanoOfSeconds % 10000000 == 0 ? 2 : (nanoOfSeconds % 1000000 == 0 ? 3 : (nanoOfSeconds % 100000 == 0 ? 4 : (nanoOfSeconds % 10000 == 0 ? 5 : (nanoOfSeconds % 1000 == 0 ? 6 : (nanoOfSeconds % 100 == 0 ? 7 : (nanoOfSeconds % 10 == 0 ? 8 : 9)))))));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.precision < precision) {
                this.precision = precision;
            }
        }

        public void stat(String value) {
            char ch;
            ++this.values;
            if (value == null || value.isEmpty()) {
                ++this.nulls;
                return;
            }
            int len = value.length();
            boolean nonAscii = false;
            for (int i = 0; i < value.length(); ++i) {
                ch = value.charAt(i);
                if (ch <= '\u007f') continue;
                nonAscii = true;
                break;
            }
            if (nonAscii) {
                if (this.precision < len) {
                    this.precision = len;
                }
                ++this.nonAsciiStrings;
                return;
            }
            int precision = len;
            if (TypeUtils.isNumber(value)) {
                ch = value.charAt(0);
                if (ch == '+' || ch == '-') {
                    --precision;
                }
                ++this.numbers;
                if (TypeUtils.isInteger(value)) {
                    ++this.integers;
                } else {
                    boolean e = false;
                    int dotIndex = -1;
                    for (int i = 0; i < value.length(); ++i) {
                        char b = value.charAt(i);
                        if (b == '.') {
                            dotIndex = i;
                            continue;
                        }
                        if (b != 'e' && b != 'E') continue;
                        e = true;
                    }
                    if (e) {
                        ++this.doubles;
                    } else if (dotIndex != -1) {
                        int scale = value.length() - dotIndex - 1;
                        if (this.scale < scale) {
                            this.scale = scale;
                        }
                        --precision;
                    }
                }
            } else {
                boolean checkDate = false;
                int sub = 0;
                int slash = 0;
                int colon = 0;
                int dot = 0;
                int nums = 0;
                block10: for (int i = 0; i < value.length(); ++i) {
                    char ch2 = value.charAt(i);
                    switch (ch2) {
                        case '-': {
                            ++sub;
                            continue block10;
                        }
                        case '/': {
                            ++slash;
                            continue block10;
                        }
                        case ':': {
                            ++colon;
                            continue block10;
                        }
                        case '.': {
                            ++dot;
                            continue block10;
                        }
                        default: {
                            if (ch2 < '0' || ch2 > '9') continue block10;
                            ++nums;
                        }
                    }
                }
                if (!(checkDate || sub != 2 && slash != 2 && colon != 2)) {
                    checkDate = true;
                }
                if (checkDate && (nums < 4 || len > 36)) {
                    checkDate = false;
                }
                if (checkDate) {
                    try {
                        int nanoOfSeconds;
                        ZonedDateTime zdt = DateUtils.parseZonedDateTime(value);
                        if (zdt != null) {
                            precision = 0;
                            ++this.dates;
                        }
                        if ((nanoOfSeconds = zdt.getNano()) != 0) {
                            precision = nanoOfSeconds % 100000000 == 0 ? 1 : (nanoOfSeconds % 10000000 == 0 ? 2 : (nanoOfSeconds % 1000000 == 0 ? 3 : (nanoOfSeconds % 100000 == 0 ? 4 : (nanoOfSeconds % 10000 == 0 ? 5 : (nanoOfSeconds % 1000 == 0 ? 6 : (nanoOfSeconds % 100 == 0 ? 7 : (nanoOfSeconds % 10 == 0 ? 8 : 9)))))));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.precision < precision) {
                this.precision = precision;
            }
        }

        public String getInferSQLType() {
            if (this.nonAsciiStrings > 0 || this.nulls == this.values) {
                return "STRING";
            }
            if (this.values == this.dates + this.nulls) {
                if (this.precision != 0) {
                    return "TIMESTAMP";
                }
                return "DATETIME";
            }
            if (this.values == this.integers + this.nulls) {
                if (this.precision < 10) {
                    return "INT";
                }
                if (this.precision < 20) {
                    return "BIGINT";
                }
                return "DECIMAL(" + this.precision + ", 0)";
            }
            if (this.values == this.numbers + this.nulls) {
                if (this.doubles > 0 || this.scale > 5) {
                    return "DOUBLE";
                }
                int precision = this.precision;
                if (precision < 19) {
                    precision = 19;
                }
                return "DECIMAL(" + precision + ", " + this.scale + ")";
            }
            return "STRING";
        }

        public Type getInferType() {
            if (this.nonAsciiStrings > 0 || this.nulls == this.values) {
                return String.class;
            }
            if (this.values == this.booleans + this.nulls) {
                return Boolean.class;
            }
            if (this.values == this.dates + this.nulls) {
                if (this.precision != 0) {
                    return Instant.class;
                }
                return Date.class;
            }
            if (this.doubles > 0) {
                return Double.class;
            }
            if (this.values == this.integers + this.nulls) {
                if (this.precision < 10) {
                    return Integer.class;
                }
                if (this.precision < 20) {
                    return Long.class;
                }
                return BigInteger.class;
            }
            if (this.values == this.numbers + this.nulls) {
                return BigDecimal.class;
            }
            if (this.arrays > 0) {
                return Collection.class;
            }
            if (this.maps > 0) {
                return Map.class;
            }
            return String.class;
        }
    }

    public static enum Feature {
        IgnoreEmptyLine(1L),
        ErrorAsNull(2L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }
}

