/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.util.CommonUtil;
import com.xiaomi.mone.tpc.login.util.SignUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.UserInfoVO;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCasFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthCasFilter.class);
    private String[] publicKeys = null;
    private String[] ignoreUrls;

    public void init(FilterConfig filterConfig) throws ServletException {
        String publicKeyStr = filterConfig.getInitParameter("AEGIS_SDK_PUBLIC_KEY");
        if (StringUtils.isBlank((CharSequence)publicKeyStr)) {
            throw new IllegalArgumentException("CAS_PUBLIC_KEY must config");
        }
        this.publicKeys = publicKeyStr.split("[,|\uff0c]");
        String ignoreUrl = filterConfig.getInitParameter("IGNORE_URL");
        if (StringUtils.isNotBlank((CharSequence)ignoreUrl)) {
            this.ignoreUrls = ignoreUrl.split("[,|\uff0c]");
            log.info("\u5df2\u8bbe\u7f6e\u5ffd\u7565\u8def\u5f84\uff0cignoreUrls:{}", (Object)ignoreUrl);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (log.isDebugEnabled()) {
                this.httpHeaderLog(httpServletRequest);
            }
            String url = ((HttpServletRequest)request).getRequestURI();
            log.info("AuthCasFilter begin filter url:{}", (Object)url);
            if (CommonUtil.isIgnoreUrl(this.ignoreUrls, url)) {
                log.info("\u914d\u7f6e\u4e3a\u5ffd\u7565\u7684\u8def\u5f84,url:{}", (Object)url);
                chain.doFilter(request, response);
                return;
            }
            String verifyIdentitySignData = httpServletRequest.getHeader("X-Proxy-Midun");
            if (StringUtils.isEmpty((CharSequence)verifyIdentitySignData)) {
                log.error("\u6ca1\u6709\u6807\u8bc6\u8eab\u4efd\u7684\u7b7e\u540d\u6570\u636e,url:{}", (Object)url);
                this.noAuthResponse(response);
                return;
            }
            String currentUsePublicKey = null;
            String verifyIdentityData = null;
            for (String key : this.publicKeys) {
                verifyIdentityData = SignUtil.verifySignGetInfo(verifyIdentitySignData, key);
                if (!StringUtils.isNotEmpty((CharSequence)verifyIdentityData)) continue;
                currentUsePublicKey = key;
                break;
            }
            if (StringUtils.isEmpty(verifyIdentityData)) {
                log.error("\u68c0\u6d4b\u8eab\u4efd,\u9a8c\u7b7e\u5931\u8d25,url:{},signData:{}", (Object)url, (Object)verifyIdentitySignData);
                this.noAuthResponse(response);
                return;
            }
            log.info("\u8d26\u53f7\u767b\u5f55,url:{}", (Object)url);
            String signAndUserSignData = httpServletRequest.getHeader("x-proxy-userdetail");
            if (StringUtils.isEmpty((CharSequence)signAndUserSignData)) {
                log.info("\u786e\u8ba4\u8bf7\u6c42\uff0c\u6ca1\u6709\u7b7e\u540d\u7528\u6237\u6570\u636e(bypass|\u9759\u6001\u8d44\u6e90)\uff0curl:{}", (Object)url);
                chain.doFilter(request, response);
                return;
            }
            String userJson = SignUtil.verifySignGetInfo(signAndUserSignData, currentUsePublicKey);
            if (StringUtils.isEmpty((CharSequence)userJson)) {
                log.error("\u83b7\u53d6\u7528\u6237\u6570\u636e\uff0c\u9a8c\u7b7e\u5931\u8d25,url:{},signData:{}", (Object)url, (Object)signAndUserSignData);
                this.noAuthResponse(response);
                return;
            }
            Gson gson = new GsonBuilder().serializeNulls().create();
            UserInfoVO userInfo = (UserInfoVO)gson.fromJson(userJson, UserInfoVO.class);
            AuthUserVo authUserVo = new AuthUserVo();
            authUserVo.setUserType(UserTypeEnum.CAS_TYPE.getCode());
            authUserVo.setAccount(userInfo.getUser());
            authUserVo.setName(userInfo.getDisplayName());
            authUserVo.setEmail(userInfo.getEmail());
            authUserVo.setAvatarUrl(userInfo.getAvatar());
            authUserVo.setCasUid(userInfo.getuID());
            authUserVo.setDepartmentName(userInfo.getDepartmentName());
            request.setAttribute("TPC_USER", (Object)authUserVo);
            log.info("AuthCasFilter check success,url:{}", (Object)url);
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            log.error("AuthCasFilter check exception", t);
            throw new ServletException(t);
        }
    }

    private void noAuthResponse(ServletResponse response) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setStatus(401);
    }

    private void httpHeaderLog(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            map.put(header, request.getHeader(header));
        }
        Gson gson = new Gson();
        log.debug("http all header>>>>{}", (Object)gson.toJson(map));
    }

    public void destroy() {
        log.info("AuthCasFilter destroy finish..");
    }
}

