/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.xiaomi.youpin.docean.common.StringUtils;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosNaming {
    private static final Logger log = LoggerFactory.getLogger(NacosNaming.class);
    private String serverAddr;
    private String username;
    private String password;
    private String addr;
    private NamingService namingService;

    public void init() {
        if (this.serverAddr == null || this.serverAddr.length() == 0) {
            throw new RuntimeException("serverAddr = null");
        }
        this.addr = this.serverAddr;
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        if (!StringUtils.isEmpty((String)this.username)) {
            properties.put("username", this.username);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            properties.put("password", this.password);
        }
        try {
            this.namingService = NacosFactory.createNamingService((Properties)properties);
        }
        catch (Exception e) {
            log.error("[NacosNaming.init] fail to init , serverAddr:{}, dataId: {}, group: {}, msg: {}", (Object)this.serverAddr, (Object)e.getCause());
        }
    }

    public void registerInstance(String serviceName, String ip, int port) throws NacosException {
        this.namingService.registerInstance(serviceName, ip, port);
    }

    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        this.namingService.registerInstance(serviceName, instance);
    }

    public void registerInstance(String serviceName, String ip, int port, String group) throws NacosException {
        if (!StringUtils.isEmpty((String)group)) {
            serviceName = group + ":" + (String)serviceName;
        }
        this.registerInstance((String)serviceName, ip, port);
    }

    public void deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        this.namingService.deregisterInstance(serviceName, ip, port);
    }

    public void deregisterInstance(String serviceName, String ip, int port, String group) throws NacosException {
        if (!StringUtils.isEmpty((String)group)) {
            serviceName = group + ":" + (String)serviceName;
        }
        this.deregisterInstance((String)serviceName, ip, port);
    }

    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.namingService.getAllInstances(serviceName);
    }

    public void subscribe(String serviceName, EventListener listener) {
        try {
            this.namingService.subscribe(serviceName, listener);
        }
        catch (NacosException e) {
            log.error("nacos subscribe error:{}", (Object)e.getMessage());
        }
    }

    public void unsubscribe(String serviceName, EventListener eventListener) {
        try {
            this.namingService.unsubscribe(serviceName, eventListener);
        }
        catch (NacosException e) {
            log.error("nacos unsubscribe error:{}", (Object)e.getMessage());
        }
    }

    private String getNamingServer() {
        String[] array = this.addr.split(",");
        if (array.length > 0) {
            return array[0];
        }
        throw new RuntimeException("serverAddr is null");
    }

    public ListView<String> getServicesOfServer(int page, int pagesize) {
        try {
            return this.namingService.getServicesOfServer(page, pagesize);
        }
        catch (NacosException e) {
            log.error("getServicesOfServer error:{}", (Object)e.getMessage());
            return null;
        }
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

