/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfig {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfig.class);
    private String serverAddr;
    private String dataId;
    private String group;
    private ConfigService configService;

    public void init() {
        if (this.serverAddr == null || this.serverAddr.length() == 0) {
            return;
        }
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        try {
            this.configService = NacosFactory.createConfigService((Properties)properties);
        }
        catch (Exception e) {
            logger.error("[NacosConfig.init] fail to init nacos config, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, this.dataId, this.group, e.getCause()});
        }
    }

    public void addListener(String dataId, String group, Listener listener) {
        try {
            this.configService.addListener(dataId, group, listener);
        }
        catch (Exception e) {
            logger.error("[NacosConfig.addListener] fail to add config listener, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, dataId, group, e.getMessage()});
        }
    }

    public void removeListener(String dataId, String group, Listener listener) {
        try {
            this.configService.removeListener(dataId, group, listener);
        }
        catch (Exception e) {
            logger.error("[NacosConfig.addListener] fail to remove config listener, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, dataId, group, e.getMessage()});
        }
    }

    public boolean close() {
        try {
            logger.info("nacos client close");
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public String getConfig(String key) {
        try {
            Map<String, String> configMap = this.getConfigMap();
            return configMap.get(key);
        }
        catch (Exception e) {
            logger.error("[NacosConfig.getConfig] fail to get config, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, this.dataId, this.group, e.getMessage()});
            return "";
        }
    }

    public Map<String, String> getConfig() {
        try {
            return this.getConfigMap();
        }
        catch (Exception e) {
            logger.error(String.format("[NacosConfig.getConfig] fail to get config, serverAddr:%s, dataId: %s, group: %s", this.serverAddr, this.dataId, this.group), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.getConfig().forEach(consumer);
    }

    private Map<String, String> getConfigMap() throws NacosException {
        String content = this.configService.getConfig(this.dataId, this.group, 5000L);
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (content != null && content.length() != 0) {
            String[] perConfig;
            for (String it : perConfig = content.split("\n|\r\n")) {
                int index;
                if (it == null || it.length() == 0 || it.startsWith("#") || (index = it.indexOf("=")) <= -1) continue;
                configMap.put(it.substring(0, index), it.substring(index + 1));
            }
        }
        return configMap;
    }

    public String getConfigStr(String dataId, String group, long timeout) {
        String content = this.configService.getConfig(dataId, group, timeout);
        return content;
    }

    public String getConfigStr(long timeout) {
        String content = this.configService.getConfig(this.dataId, this.group, timeout);
        return content;
    }

    public boolean publishConfig(String dataId, String group, String content) {
        return this.configService.publishConfig(dataId, group, content);
    }

    public boolean publishConfig(String content) throws NacosException {
        return this.configService.publishConfig(this.dataId, this.group, content);
    }

    public boolean deleteConfig(String dataId, String group) throws NacosException {
        return this.configService.removeConfig(dataId, group);
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

