/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.common;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeRun {
    private static final Logger log = LoggerFactory.getLogger(SafeRun.class);

    public static boolean run(SafeSupplier<Boolean> supplier, String name, long sleepTime) {
        try {
            return supplier.get();
        }
        catch (Throwable ex) {
            log.error("safe run {} error:{} ", (Object)name, (Object)ex.getMessage());
            if (sleepTime > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return false;
        }
    }

    public static void run(SafeRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            log.error("safe run  error:" + ex.getMessage(), ex);
        }
    }

    @FunctionalInterface
    public static interface SafeSupplier<T> {
        public T get() throws Exception;
    }

    public static interface SafeRunnable {
        public void run() throws Throwable;
    }
}

