/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.mvc.HttpResponseUtils;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import com.xiaomi.youpin.docean.mvc.session.HttpSessionManager;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

public class MvcResponse {
    private ChannelHandlerContext ctx;

    public void writeAndFlush(MvcContext context, HttpResponseStatus status, String message) {
        if (context.isWebsocket()) {
            TextWebSocketFrame frame = new TextWebSocketFrame(message);
            this.ctx.writeAndFlush((Object)frame);
        } else {
            FullHttpResponse response = HttpResponseUtils.create((FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])message.getBytes())));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)message.getBytes().length);
            if (StringUtils.isNotEmpty(context.getContentType())) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)context.getContentType());
            }
            context.getResHeaders().forEach((k, v) -> response.headers().set(k, v));
            if (context.isAllowCross()) {
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"*");
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)"GET, POST, PUT,DELETE");
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
            }
            if (context.isCookie()) {
                HttpSessionManager.setSessionId(context, HttpSessionManager.isHasSessionId(context.getHeaders()), response);
            }
            if (StringUtils.isNotEmpty(context.getRequest().headers().get((CharSequence)HttpHeaderNames.CONNECTION))) {
                response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)context.getRequest().headers().get((CharSequence)HttpHeaderNames.CONNECTION));
            }
            this.ctx.writeAndFlush((Object)response);
        }
    }

    public void writeAndFlush(MvcContext context, String message) {
        this.writeAndFlush(context, message, HttpResponseStatus.OK.code());
    }

    public void writeAndFlush(MvcContext context, String message, int code) {
        HttpResponseStatus responseStatus = HttpResponseStatus.valueOf((int)code);
        String status = context.getResHeaders().get("x-status");
        if (null != status) {
            responseStatus = HttpResponseStatus.valueOf((int)Integer.valueOf(status));
        }
        this.writeAndFlush(context, responseStatus, message);
    }

    public void clear() {
        this.ctx = null;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }
}

