/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.db.interceptor;

import org.nutz.dao.DaoException;
import org.nutz.dao.DaoInterceptor;
import org.nutz.dao.DaoInterceptorChain;
import org.nutz.lang.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoTimeInterceptor
implements DaoInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DaoTimeInterceptor.class);
    private boolean printSql = true;

    public DaoTimeInterceptor() {
    }

    public DaoTimeInterceptor(String printSql) {
        this.printSql = Boolean.parseBoolean(printSql);
    }

    public DaoTimeInterceptor(boolean printSql) {
        this.printSql = printSql;
    }

    public void filter(DaoInterceptorChain chain) throws DaoException {
        Stopwatch sw = Stopwatch.begin();
        try {
            chain.doChain();
        }
        finally {
            sw.stop();
            if (this.printSql) {
                log.info("time={}ms, sql={}", (Object)sw.getDuration(), (Object)chain.getDaoStatement().toString());
            }
        }
    }

    public void setPrintSql(boolean printSql) {
        this.printSql = printSql;
    }
}

