/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.aop.action;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.ozhera.monitor.bo.AlertGroupInfo;
import org.apache.ozhera.monitor.bo.AlertGroupParam;
import org.apache.ozhera.monitor.bo.HeraReqInfo;
import org.apache.ozhera.monitor.bo.OperLogAction;
import org.apache.ozhera.monitor.dao.model.HeraOperLog;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionArg2;
import org.apache.ozhera.monitor.service.aop.helper.HeraRequestMappingActionAlertGroupHelper;
import org.nutz.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeraRequestMappingActionAlertGroupAdd
extends HeraRequestMappingActionArg2<HttpServletRequest, AlertGroupParam, Result<AlertGroupInfo>> {
    private static final Logger log = LoggerFactory.getLogger(HeraRequestMappingActionAlertGroupAdd.class);
    @Autowired
    private HeraRequestMappingActionAlertGroupHelper heraRequestMappingActionAlertGroupHelper;

    @Override
    public void beforeAction(HttpServletRequest arg1, AlertGroupParam arg2, HeraReqInfo heraReqInfo) {
        HeraOperLog operLog = new HeraOperLog();
        operLog.setOperName(heraReqInfo.getUser());
        operLog.setModuleName(heraReqInfo.getModuleName());
        operLog.setInterfaceName(heraReqInfo.getInterfaceName());
        operLog.setInterfaceUrl(heraReqInfo.getReqUrl());
        operLog.setAction(OperLogAction.ALERT_GROUP_ADD.getAction());
        this.heraRequestMappingActionAlertGroupHelper.saveHeraOperLogs(null, operLog, heraReqInfo);
        if (operLog.getId() != null) {
            heraReqInfo.setOperLog(operLog);
        }
    }

    @Override
    public void afterAction(HttpServletRequest arg1, AlertGroupParam arg2, HeraReqInfo heraReqInfo, Result<AlertGroupInfo> result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", result.getCode());
        resultMap.put("message", result.getMessage());
        heraReqInfo.getOperLog().setResultDesc(Json.toJson(resultMap));
        this.heraRequestMappingActionAlertGroupHelper.saveHeraOperLogs(result, heraReqInfo.getOperLog(), heraReqInfo);
    }
}

