/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.alertmanager.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaomi.mone.tpc.api.service.UserFacade;
import com.xiaomi.mone.tpc.common.enums.UserStatusEnum;
import com.xiaomi.mone.tpc.common.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.common.param.UserQryParam;
import com.xiaomi.mone.tpc.common.vo.PageDataVo;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.youpin.infra.rpc.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.monitor.bo.UserInfo;
import org.apache.ozhera.monitor.service.alertmanager.AlertManager;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.alarm.duty.DutyInfo;
import org.apache.ozhera.prometheus.agent.api.service.PrometheusAlertService;
import org.apache.ozhera.prometheus.agent.param.alert.RuleAlertParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="openSourceAlertManager")
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class AlertManagerImpl
implements AlertManager {
    private static final Logger log = LoggerFactory.getLogger(AlertManagerImpl.class);
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=PrometheusAlertService.class, group="${dubbo.group.alert}")
    PrometheusAlertService prometheusAlertService;
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=UserFacade.class, group="${dubbo.group.tpc}", version="1.0")
    private UserFacade userFacade;
    private static Gson gson = new Gson();

    @Override
    public org.apache.ozhera.monitor.result.Result addRule(JsonObject param, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            RuleAlertParam ruleAlertParam = (RuleAlertParam)new Gson().fromJson(new Gson().toJson((JsonElement)param), RuleAlertParam.class);
            org.apache.ozhera.prometheus.agent.result.Result ruleAlert = this.prometheusAlertService.createRuleAlert(ruleAlertParam);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)ruleAlert), org.apache.ozhera.monitor.result.Result.class);
            log.info("open alert add, request : {} ,result:{}", (Object)new Gson().toJson((Object)ruleAlertParam), (Object)new Gson().toJson((Object)ruleAlert));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result editRule(Integer alertId, JsonObject param, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        log.info("open alert update api param :{}", (Object)param.toString());
        try {
            RuleAlertParam ruleAlertParam = (RuleAlertParam)new Gson().fromJson(new Gson().toJson((JsonElement)param), RuleAlertParam.class);
            org.apache.ozhera.prometheus.agent.result.Result ruleAlert = this.prometheusAlertService.UpdateRuleAlert(String.valueOf(alertId), ruleAlertParam);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)ruleAlert), org.apache.ozhera.monitor.result.Result.class);
            log.info("open alert update request,alertId:{}, param : {} ,result:{}", new Object[]{alertId, new Gson().toJson((Object)ruleAlertParam), new Gson().toJson((Object)ruleAlert)});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result delRule(Integer alertId, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            org.apache.ozhera.prometheus.agent.result.Result ruleAlert = this.prometheusAlertService.DeleteRuleAlert(String.valueOf(alertId));
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)ruleAlert), org.apache.ozhera.monitor.result.Result.class);
            log.info("open alert delete request,alertId:{}, result:{}", (Object)alertId, (Object)new Gson().toJson((Object)ruleAlert));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result enableRule(Integer alertId, Integer pauseStatus, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            org.apache.ozhera.prometheus.agent.result.Result ruleAlert = this.prometheusAlertService.EnabledRuleAlert(String.valueOf(alertId), String.valueOf(pauseStatus));
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)ruleAlert), org.apache.ozhera.monitor.result.Result.class);
            log.info("open alert enableRule request,alertId:{}, pauseStatus:{},result:{}", new Object[]{alertId, pauseStatus, new Gson().toJson((Object)ruleAlert)});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result queryRuels(JsonObject params, String identifyId, String user) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonElement> getAlarmRuleRemote(Integer alarmId, Integer iamId, String user) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result updateAlarm(Integer alarmId, Integer iamId, String user, String body) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonElement> addAlarmGroup(JsonObject params, String iamId, String user) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonElement> searchAlarmGroup(String alarmGroup, String identifyId, String user) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<PageData> searchAlertTeam(String name, String note, String manager, String oncallUser, String service, Integer iamId, String user, Integer page_no, Integer page_size) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<PageData> queryEvents(String user, Integer treeId, String alertLevel, Long startTime, Long endTime, Integer pageNo, Integer pageSize, JsonObject labels) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<PageData> queryLatestEvents(Set<Integer> treeIdSet, String alertStat, String alertLevel, Long startTime, Long endTime, Integer pageNo, Integer pageSize, JsonObject labels) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonObject> getEventById(String user, Integer treeId, String eventId) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<PageData> getAlertGroupPageData(String user, String name, int pageNo, int pageSize) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonObject> resolvedEvent(String user, Integer treeId, String alertName, String comment, Long startTime, Long endTime) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<PageData<List<UserInfo>>> searchUser(String user, String searchName, int pageNo, int pageSize) {
        PageData page = new PageData();
        page.setPage(pageNo);
        page.setPageSize(pageSize);
        page.setTotal(0L);
        AuthUserVo userVo = UserUtil.parseFullAccount((String)user);
        UserQryParam param = new UserQryParam();
        param.setAccount(userVo.getAccount());
        param.setUserType(userVo.getUserType());
        param.setStatus(UserStatusEnum.ENABLE.getCode());
        param.setPager(Boolean.valueOf(true));
        AuthUserVo userVoSearch = UserUtil.parseFullAccount((String)searchName);
        param.setUserAcc(userVoSearch == null ? null : userVoSearch.getAccount());
        Result userResult = this.userFacade.list(param);
        log.info("userFacade request param:{},result:{}", (Object)gson.toJson((Object)param), (Object)gson.toJson((Object)userResult));
        if (userResult == null || userResult.getData() == null || CollectionUtils.isEmpty((Collection)((PageDataVo)userResult.getData()).getList())) {
            return org.apache.ozhera.monitor.result.Result.success(page);
        }
        page.setTotal(Long.valueOf(((PageDataVo)userResult.getData()).getTotal()));
        ArrayList userInfos = new ArrayList();
        ((PageDataVo)userResult.getData()).getList().forEach(vo -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(vo.getId());
            userInfo.setName(vo.getAccount());
            userInfo.setType(vo.getType());
            StringBuilder cname = new StringBuilder();
            cname.append(vo.getAccount()).append("(").append(UserTypeEnum.getEnum((Integer)vo.getType()).getDesc()).append(")");
            userInfo.setCname(cname.toString());
            userInfo.setShowAccount(vo.getShowAccount());
            userInfos.add(userInfo);
        });
        page.setList(userInfos);
        return org.apache.ozhera.monitor.result.Result.success(page);
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonObject> createAlertGroup(String user, String name, String note, String chatId, List<Long> memberIds, DutyInfo dutyInfo) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonObject> getAlertGroup(String user, long id) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonObject> editAlertGroup(String user, long id, String name, String note, String chatId, List<Long> memberIds, DutyInfo dutyInfo) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonObject> deleteAlertGroup(String user, long id) {
        return null;
    }

    @Override
    public org.apache.ozhera.monitor.result.Result<JsonElement> dutyInfoList(String user, long id, Long start, Long Long2) {
        return null;
    }

    @Override
    public Integer getDefaultIamId() {
        return 0;
    }
}

