/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.ozhera.monitor.dao.mapper.GrafanaTemplateMapper;
import org.apache.ozhera.monitor.dao.model.GrafanaTemplate;
import org.apache.ozhera.monitor.dao.model.GrafanaTemplateExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GrafanaTemplateDao {
    private static final Logger log = LoggerFactory.getLogger(GrafanaTemplateDao.class);
    @Autowired
    private GrafanaTemplateMapper grafanaTemplateMapper;

    public int insert(GrafanaTemplate template) {
        template.setCreateTime(new Date());
        template.setUpdateTime(new Date());
        try {
            int result = this.grafanaTemplateMapper.insert(template);
            if (result < 0) {
                log.warn("[GrafanaTemplateDao.insert] failed to insert GrafanaTemplateDao: {}", (Object)template.getName());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.insert] failed to insert GrafanaTemplateDao: {}, err: {}", (Object)template.getName(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int update(GrafanaTemplate template) {
        template.setUpdateTime(new Date());
        try {
            int result = this.grafanaTemplateMapper.updateByPrimaryKeyWithBLOBs(template);
            if (result < 0) {
                log.warn("[GrafanaTemplateDao.update] failed to update GrafanaTemplateDao: {}", (Object)template.getName());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.update] failed to update GrafanaTemplateDao: {}, err: {}", (Object)template.getName(), (Object)e);
            return 0;
        }
        return 1;
    }

    public GrafanaTemplate fetchOneByName(String name) {
        try {
            GrafanaTemplateExample aje = new GrafanaTemplateExample();
            aje.setOrderByClause("id desc");
            aje.createCriteria().andNameEqualTo(name).andDeletedEqualTo(false);
            List<GrafanaTemplate> grafanaTemplates = this.grafanaTemplateMapper.selectByExampleWithBLOBs(aje);
            if (grafanaTemplates.size() >= 1) {
                return grafanaTemplates.get(0);
            }
            return null;
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.fetchOneByName] failed to fetchOneByName name: {}, err: {}", (Object)name, (Object)e);
            return null;
        }
    }

    public GrafanaTemplate fetchById(int id) {
        try {
            GrafanaTemplateExample aje = new GrafanaTemplateExample();
            aje.setOrderByClause("id desc");
            aje.createCriteria().andIdEqualTo(id).andDeletedEqualTo(false);
            List<GrafanaTemplate> grafanaTemplates = this.grafanaTemplateMapper.selectByExampleWithBLOBs(aje);
            if (grafanaTemplates.size() >= 1) {
                return grafanaTemplates.get(0);
            }
            return null;
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.fetchById] failed to fetchById id: {}, err: {}", (Object)id, (Object)e);
            return null;
        }
    }

    public int delete(int id) {
        try {
            GrafanaTemplate grafanaTemplate = this.grafanaTemplateMapper.selectByPrimaryKey(id);
            grafanaTemplate.setDeleted(true);
            int result = this.grafanaTemplateMapper.updateByPrimaryKeyWithBLOBs(grafanaTemplate);
            if (result < 0) {
                log.warn("[GrafanaTemplateDao.delete] failed to delete id: {}", (Object)id);
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.delete] failed to delete id: {}, err: {}", (Object)id, (Object)e);
            return 0;
        }
    }

    public int deleteHard(int id) {
        try {
            GrafanaTemplate grafanaTemplate = this.grafanaTemplateMapper.selectByPrimaryKey(id);
            int result = this.grafanaTemplateMapper.deleteByPrimaryKey(id);
            if (result < 0) {
                log.warn("[GrafanaTemplateDao.deleteHard] failed to delete id: {}", (Object)id);
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.deleteHard] failed to delete id: {}, err: {}", (Object)id, (Object)e);
            return 0;
        }
    }

    public List<GrafanaTemplate> list(int pageSize, int pageNo) {
        GrafanaTemplateExample aje = new GrafanaTemplateExample();
        aje.setOrderByClause("id desc");
        aje.setLimit(pageSize);
        aje.setOffset((pageNo - 1) * pageSize);
        aje.createCriteria().andDeletedEqualTo(false);
        try {
            List<GrafanaTemplate> list = this.grafanaTemplateMapper.selectByExample(aje);
            if (list == null) {
                log.warn("[GrafanaTemplateDao.list] failed to search");
            }
            return list;
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.list] failed to search err: {}", (Object)e.toString());
            return null;
        }
    }

    public Long getTotal() {
        GrafanaTemplateExample aje = new GrafanaTemplateExample();
        aje.createCriteria().andDeletedEqualTo(false);
        try {
            Long result = this.grafanaTemplateMapper.countByExample(aje);
            if (result == null) {
                log.warn("[GrafanaTemplateDao.getTotal] failed to search");
            }
            return result;
        }
        catch (Exception e) {
            log.error("[GrafanaTemplateDao.getTotal] failed to search err: {}", (Object)e.toString());
            return null;
        }
    }

    public List<GrafanaTemplate> search(GrafanaTemplate template) {
        GrafanaTemplateExample aje = new GrafanaTemplateExample();
        GrafanaTemplateExample.Criteria ca = aje.createCriteria();
        if (template.getAppType() != null) {
            ca.andAppTypeEqualTo(template.getAppType());
        }
        if (template.getLanguage() != null) {
            ca.andLanguageEqualTo(template.getLanguage());
        }
        if (template.getPlatform() != null) {
            ca.andPlatformEqualTo(template.getPlatform());
        }
        ca.andDeletedEqualTo(false);
        return this.grafanaTemplateMapper.selectByExampleWithBLOBs(aje);
    }
}

