/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.serialize.hessian;

import com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.serialize.hessian.Hessian2SerializerFactory;

public class Hessian2ObjectOutput
implements ObjectOutput {
    private final Hessian2Output output;

    public Hessian2ObjectOutput(OutputStream os) {
        this.output = new Hessian2Output(os);
        this.output.setSerializerFactory(Hessian2SerializerFactory.INSTANCE);
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.output.writeBoolean(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.output.writeInt((int)v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.output.writeInt((int)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.output.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.output.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.output.writeDouble((double)v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.output.writeDouble(v);
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.output.writeBytes(b);
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.output.writeBytes(b, off, len);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.output.writeString(v);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.output.writeObject(obj);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.output.flushBuffer();
    }
}

